/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.utils;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ThreadLocalRandom;
import oracle.pgx.common.util.FileUtils;
import oracle.pgx.common.util.StringUtils;

public final class RandomUtils {
    private static final int NUM_BITS = 130;
    private static final int RADIX = 32;

    private RandomUtils() {
    }

    public static String randomString() {
        return new BigInteger(130, ThreadLocalRandom.current()).toString(32);
    }

    public static String randomString(int numBits) {
        return new BigInteger(numBits, ThreadLocalRandom.current()).toString(32);
    }

    public static String randomString(int numBits, int radix) {
        return new BigInteger(numBits, ThreadLocalRandom.current()).toString(radix);
    }

    public static String randomStringWithLength(int length) {
        return StringUtils.leftPad(new BigInteger(length, ThreadLocalRandom.current()).toString(2), length);
    }

    public static File createTmpDir(String baseDir, String dirPrefix) throws IOException {
        return RandomUtils.createTmpDir(baseDir, dirPrefix, true);
    }

    public static File createTmpDir(String baseDir, String dirPrefix, boolean deleteOnExit) throws IOException {
        Path path;
        if (baseDir == null) {
            path = Files.createTempDirectory(dirPrefix, new FileAttribute[0]);
        } else {
            String baseDirCanonicalPath = new File(baseDir).getCanonicalPath();
            Files.createDirectories(Paths.get(baseDirCanonicalPath, new String[0]), new FileAttribute[0]);
            path = Files.createTempDirectory(Paths.get(baseDirCanonicalPath, new String[0]), dirPrefix, new FileAttribute[0]);
        }
        File directory = path.toFile();
        if (deleteOnExit) {
            FileUtils.forceDeleteOnExit(directory);
        }
        return directory;
    }
}

