/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.utils;

import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import oracle.pgx.common.PgxCharset;
import oracle.pgx.common.PgxId;

public final class IdGenerator {
    private IdGenerator() {
    }

    public static PgxId generateRandomUuid() {
        return new PgxId(UUID.randomUUID());
    }

    public static PgxId generateRandomUuidWithoutCollision(Set<PgxId> usedIds) {
        return IdGenerator.generateRandomUuidWithoutCollision(usedIds::contains);
    }

    public static PgxId generateRandomUuidWithoutCollision(Predicate<PgxId> existingUuidTester) {
        PgxId uuid;
        while (existingUuidTester.test(uuid = IdGenerator.generateRandomUuid())) {
        }
        return uuid;
    }

    public static PgxId generateRandomUuidWithoutCollision(Function<PgxId, Object> lookupFunction) {
        return IdGenerator.generateRandomUuidWithoutCollision((PgxId name) -> lookupFunction.apply((PgxId)name) != null);
    }

    public static PgxId generateIdFromString(String name) {
        byte[] bytes = name.getBytes(PgxCharset.getCharset());
        UUID uuid = UUID.nameUUIDFromBytes(bytes);
        return new PgxId(uuid);
    }
}

