/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.common.util.ErrorMessages;

public class PointModule
extends SimpleModule {
    public PointModule() {
        super("PointModule", Version.unknownVersion());
        this.addDeserializer(Point2D.class, new PointDeserializer());
    }

    private class PointDeserializer
    extends JsonDeserializer<Point2D> {
        private PointDeserializer() {
        }

        public Point2D deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode jsonTree = (JsonNode)jp.readValueAsTree();
            JsonNode xNode = jsonTree.get("x");
            if (xNode == null) {
                throw new JsonParseException(jp, ErrorMessages.getMessage("MISSING_JSON_FIELD", "x"));
            }
            JsonNode yNode = jsonTree.get("y");
            if (yNode == null) {
                throw new JsonParseException(jp, ErrorMessages.getMessage("MISSING_JSON_FIELD", "y"));
            }
            double stX = xNode.asDouble();
            double stY = yNode.asDouble();
            return new Point2D(stX, stY);
        }
    }
}

