/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Constants {
    public static final String ANONYMOUS = "anonymous_";
    public static final String SM_SERVER = "sm";
    public static final String DIST_SERVER = "dist";
    public static final int ARRAY_MAX_VALUE = 0x7FFFFFF0;
    public static final Character DEFAULT_VECTOR_COMPONENTS_DELIMITER = Character.valueOf(';');
    private static final String ID_SANITIZATION_REGEX = "[a-zA-Z][a-zA-Z0-9$#_]*";
    @Deprecated
    public static final Pattern ID_SANITIZATION_REGEX_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9$#_]*");
    private static final String STRING_SANITIZATION_REGEX = "[a-zA-Z0-9$#_]*";
    @Deprecated
    public static final Pattern STRING_SANITIZATION_REGEX_PATTERN = Pattern.compile("[a-zA-Z0-9$#_]*");
    public static final String SESSION_SOURCE_SANITIZATION_REGEX = "[.a-zA-Z0-9$#_-]*";
    public static final Pattern SESSION_SOURCE_SANITIZATION_REGEX_PATTERN = Pattern.compile("[.a-zA-Z0-9$#_-]*");
    public static final String STICKY_COOKIE_SANITIZATION_REGEX = "[.a-zA-Z0-9$#_-]*";
    public static final Pattern STICKY_COOKIE_SANITIZATION_REGEX_PATTERN = Pattern.compile("[.a-zA-Z0-9$#_-]*");
    public static final String PARALLEL_HINT_SANITIZATION_REGEX = "(^\\/\\*\\+ parallel[0-9() ]*\\*\\/)?$";
    public static final Pattern PARALLEL_HINT_SANITIZATION_REGEX_PATTERN = Pattern.compile("(^\\/\\*\\+ parallel[0-9() ]*\\*\\/)?$");
    public static final String UNIX_DIRECTORY_PATH_REGEX = "^(\\/[\\w\\-_.^ ]+)+\\/?$";
    public static final Pattern UNIX_DIRECTORY_PATH_REGEX_PATTERN = Pattern.compile("^(\\/[\\w\\-_.^ ]+)+\\/?$");
    public static final String WINDOWS_DIRECTORY_PATH_REGEX = "^[a-zA-Z]:(\\\\[\\w^ ]+)+\\\\?$";
    public static final Pattern WINDOWS_DIRECTORY_PATH_REGEX_PATTERN = Pattern.compile("^[a-zA-Z]:(\\\\[\\w^ ]+)+\\\\?$");
    public static final String VERTEX_TABLE_SUFFIX = "VT$";
    public static final String EDGE_TABLE_SUFFIX = "GE$";
    public static final String SESSION_IDENTIFIER = "SID";
    public static final String CSRF_TOKEN_IDENTIFIER = "_csrf_token";
    public static final String PGX_SESSION_STICKY_COOKIE_IDENTIFIER = "PGX_SESSION_STICKY_COOKIE";
    public static final String PGX_INSTANCE_STICKY_COOKIE_IDENTIFIER = "PGX_INSTANCE_STICKY_COOKIE";
    public static final String EDGE_LIST_PROP_SEPARATOR = "*";
    public static final String EDGE_LIST_VERTEX_LABELS_SEPARATOR = "*{}";
    public static final int UPDATE_THRESHOLD_DISABLED = -1;
    public static final int UPDATE_INTERVAL_DISABLED = -1;
    public static final int FETCH_INTERVAL_DISABLED = -1;
    public static final long HIGHER_32_BIT_MASK = -4294967296L;
    public static final long LOWER_32_BIT_MASK = 0xFFFFFFFFL;
    public static final String MAIN_EDGE_TABLE_NAME = "E";
    public static final int MAIN_EDGE_TABLE_SLOT = 0;
    public static final String MAIN_VERTEX_TABLE_NAME = "V";
    public static final int MAIN_VERTEX_TABLE_SLOT = 0;
    public static final String JDBC_PREFIX_WITHOUT_AT = "jdbc:oracle:thin:";
    public static final String JDBC_PREFIX = "jdbc:oracle:thin:@";
    public static final int PROCESS_TIMEOUT_SECS = 5;
    public static final OffsetDateTime DEFAULT_MIN_OFFSETDATETIME_WITH_UTC_TIMEZONE = OffsetDateTime.of(LocalDateTime.MIN, ZoneOffset.UTC);
    public static final OffsetDateTime DEFAULT_MAX_OFFSETDATETIME_WITH_UTC_TIMEZONE = OffsetDateTime.of(LocalDateTime.MAX, ZoneOffset.UTC);
    public static final OffsetTime DEFAULT_MIN_OFFSETTIME_WITH_UTC_TIMEZONE = OffsetTime.of(LocalTime.MIN, ZoneOffset.UTC);
    public static final OffsetTime DEFAULT_MAX_OFFSETTIME_WITH_UTC_TIMEZONE = OffsetTime.of(LocalTime.MAX, ZoneOffset.UTC);
    public static final int HOSTNAME_MAX_LENGTH = 225;
    public static final int SYSTEM_CLASSPATH_MAX_LENGTH = 3000000;
    public static final int SESSION_SOURCE_MAX_LENGTH = 225;
    public static final String VERTEX_LABELS_PROPERTY_NAME = "Vertex Labels";
    public static final String VERTEX_LABELS_PSEUDO_PROPERTY_NAME = "__vertex_labels__";
    public static final String EDGE_LABEL_PROPERTY_NAME = "Edge Label";
    public static final String EDGE_LABEL_PSEUDO_PROPERTY_NAME = "__edge_label__";
    public static final String EDGE_KEYS_PROPERTY_NAME = "Edge Keys";
    public static final String ASYNC_HEADER_PARAM = "Prefer";
    public static final String RESPOND_ASYNC = "respond-async";
    public static final String HTTP_ERROR_CODE_URI = "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.1";
    public static final String X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override";
    public static final String LINKS = "links";
    public static final String ENTITY = "entity";
    public static final String ID = "id";
    public static final String REDACTED_STRING_ASTERISKS = "*******";
    public static final Character DEFAULT_FILE_STORING_SEPARATOR = Character.valueOf('\t');
    public static final String DEFAULT_FILE_LOADING_SEPARATOR = "\t ";
    public static final Character DEFAULT_CSV_STORING_SEPARATOR = Character.valueOf(',');
    public static final String DEFAULT_CSV_LOADING_SEPARATOR = ",";
    public static final String PARTITIONED_URI_SEPARATOR = "_";
    public static final String PARTITIONED_GRAPH_DEFAULT_NAME = "partitioned_graph";
    public static final String GRAPH_DEFAULT_NAME = "graph";
    public static final String DEFAULT_PG_DATASOURCE_NAME = System.getenv("DATA_SOURCE_NAME");
    public static final String JNDI_DATASOURCE_PREFIX = "java:comp/env/";
    public static final long LATEST_SNAPSHOT_TIMESTAMP = -1L;
    public static final String REMOTE_LOCATIONS_ALLOWED_ALL = "*";
    public static final Set<String> REMOTE_LOCATIONS_ALLOWED_VALUES = Collections.unmodifiableSet(Stream.of("https", "ftps", "hdfs").collect(Collectors.toSet()));
    public static final double ARRAY_COMPACTION_UPPER_BOUND = 1.0;
    public static final double ARRAY_COMPACTION_LOWER_BOUND = 0.0;
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String BEARER_PREFIX = "Bearer ";
    public static final String VERTEX_PROVIDERS_VERSION_BLOCK = "vertex_providers";
    public static final String EDGE_PROVIDERS_VERSION_BLOCK = "edge_providers";
    public static final int NO_PROVIDER_INDEX = -1;
    public static final String CONNECTION_POOL_KEY = "connection_pool";
    public static final String KEYSTORE_PATH_KEY = "pgx.keystore_path";
    public static final String KEYSTORE_SECRET_KEY = "pgx.keystore_password";
    public static final String CONTROL_PLANE_PORT_KEY = "pgx.cp_port";
    public static final String CONTROL_PLANE_DN_KEY = "pgx.cp_distinguished_name";
    public static final String CLUSTER_PATH_PREFIX = "cluster/v1";
    public static final String CERTIFICATE_ATTRIBUTE_PATH = "javax.servlet.request.X509Certificate";
    public static final String LOCAL_PORT_ATTRIBUTE_PATH = "pgx.servlet.request.localPort";
    public static final String AUTH_EXCEPTIONS_KEY = "pgx.auth.exceptions";
    public static final String AUTH_EXCEPTIONS_SEPARATOR = Pattern.quote(";");
}

