/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.auth;

import java.nio.file.Path;
import java.util.Objects;
import oracle.pgx.common.auth.PgxGeneralPermission;
import oracle.pgx.common.auth.PgxResourcePermission;

public class PgxGenericPermission {
    private final PgxGeneralPermission generalPermission;
    private final String location;
    private final PgxResourcePermission resourcePermission;

    public PgxGenericPermission(PgxGeneralPermission generalPermission) {
        this.generalPermission = generalPermission;
        this.location = null;
        this.resourcePermission = null;
    }

    public PgxGenericPermission(Path location, PgxResourcePermission resourcePermission) {
        this(location.toString(), resourcePermission);
    }

    public PgxGenericPermission(String location, PgxResourcePermission resourcePermission) {
        this.generalPermission = null;
        this.location = location;
        this.resourcePermission = resourcePermission;
    }

    public boolean isGeneralPermission() {
        return this.generalPermission != null;
    }

    public boolean isFileLocationPermission() {
        return this.location != null && this.resourcePermission != null;
    }

    public PgxGeneralPermission getGeneralPermission() {
        return this.generalPermission;
    }

    public String getLocation() {
        return this.location;
    }

    public PgxResourcePermission getResourcePermission() {
        return this.resourcePermission;
    }

    public String toString() {
        if (this.isGeneralPermission()) {
            return this.generalPermission.toString();
        }
        return "{" + this.location.toString() + ": " + this.resourcePermission.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PgxGenericPermission)) {
            return false;
        }
        PgxGenericPermission other = (PgxGenericPermission)o;
        if (this.isGeneralPermission()) {
            return other.isGeneralPermission() && this.getGeneralPermission().equals((Object)other.getGeneralPermission());
        }
        return other.isFileLocationPermission() && this.getLocation().equals(other.getLocation()) && this.getResourcePermission().equals((Object)other.getResourcePermission());
    }

    public int hashCode() {
        if (this.isGeneralPermission()) {
            return Objects.hash(new Object[]{this.getGeneralPermission()});
        }
        return Objects.hash(new Object[]{this.getLocation(), this.getResourcePermission()});
    }
}

