/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.auth;

public enum PgxGeneralPermission {
    NONE,
    SESSION_CREATE,
    SESSION_NEW_GRAPH,
    SESSION_GET_PUBLISHED_GRAPH,
    SESSION_ADD_PUBLISHED_GRAPH,
    SESSION_COMPILE_ALGORITHM,
    SERVER_GET_INFO,
    SERVER_MANAGE,
    SESSION_READ_MODEL,
    SESSION_MODIFY_MODEL;


    public String toString() {
        if (this == NONE) {
            return super.toString();
        }
        return "PGX_" + super.toString();
    }

    public boolean allowsSessionCreate() {
        return this == SESSION_CREATE;
    }

    public boolean allowsCreateGraph() {
        return this == SESSION_NEW_GRAPH;
    }

    public boolean allowsGetPublishedGraph() {
        switch (this) {
            case SESSION_GET_PUBLISHED_GRAPH: 
            case SESSION_ADD_PUBLISHED_GRAPH: {
                return true;
            }
        }
        return false;
    }

    public boolean allowsPublishGraph() {
        return this == SESSION_ADD_PUBLISHED_GRAPH;
    }

    public boolean allowsCompileAlgorithm() {
        return this == SESSION_COMPILE_ALGORITHM;
    }

    public boolean allowsGetServerInfo() {
        switch (this) {
            case SERVER_GET_INFO: 
            case SERVER_MANAGE: {
                return true;
            }
        }
        return false;
    }

    public boolean allowsManageServer() {
        return this == SERVER_MANAGE;
    }

    public boolean allowsMlModelReading() {
        switch (this) {
            case SESSION_READ_MODEL: {
                return true;
            }
        }
        return false;
    }

    public boolean allowsMlModelInference() {
        switch (this) {
            case SESSION_READ_MODEL: 
            case SESSION_MODIFY_MODEL: {
                return true;
            }
        }
        return false;
    }

    public boolean allowsMlModelTraining() {
        switch (this) {
            case SESSION_MODIFY_MODEL: {
                return true;
            }
        }
        return false;
    }

    public boolean allowsMlModelStoring() {
        switch (this) {
            case SESSION_MODIFY_MODEL: {
                return true;
            }
        }
        return false;
    }

    public boolean allowsCreateFrame() {
        return this == SESSION_NEW_GRAPH;
    }

    public boolean allowsStoreFrame() {
        return this == SESSION_NEW_GRAPH;
    }

    public boolean allowsLoadFrame() {
        return this == SESSION_NEW_GRAPH;
    }
}

