/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;

public class Self {
    private String id;
    private List<Link> links;

    public Self() {
    }

    public Self(List<Link> links) {
        this.links = links;
    }

    public Self(Object id) {
        this.id = id.toString();
    }

    public Self(String id, List<Link> links) {
        this.id = id;
        this.links = links;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        if (links == null) {
            this.links = links;
            return;
        }
        ArrayList<Link> list = new ArrayList<Link>(links);
        Optional<Link> canonical = Self.getCanonicalLink(links);
        if (canonical.isPresent()) {
            list.add(canonical.get());
        }
        this.links = list;
    }

    public void addLinks(Link ... link) {
        this.setLinks(Arrays.asList(link));
    }

    public void injectLinks() {
    }

    public static Optional<Link> getCanonicalLink(List<Link> links) {
        Optional<Link> self = links.stream().filter(link -> link.getRel().equals(LinkRel.SELF.toString())).findFirst().map(link -> new Link(LinkRel.CANONICAL, URI.create(link.getHref())));
        return self;
    }
}

