/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import oracle.pgx.common.LinkRel;

public class Link {
    private String href;
    private String rel;
    private Method method;
    private List<String> interaction = Collections.singletonList("async-polling");

    public Link() {
    }

    public Link(LinkRel rel, URI href, boolean isSync) {
        this.href = href.toString();
        this.rel = rel.toString();
        this.method = Method.GET;
        if (isSync) {
            this.interaction = Collections.singletonList("sync");
        }
    }

    public Link(LinkRel rel, URI href) {
        this(rel, href, false);
    }

    public Link(URI href, LinkRel rel, Method method) {
        this.href = href.toString();
        this.rel = rel.toString();
        this.method = method;
    }

    public String getHref() {
        return this.href;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getRel() {
        return this.rel;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public List<String> getInteraction() {
        return this.interaction;
    }

    public static enum Method {
        PUT,
        GET,
        DELETE,
        POST,
        PATCH;

    }
}

