/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class Either<L, R> {
    public static <L, R> Either<L, R> left(final L value) {
        return new Either<L, R>(){

            @Override
            public <T> T map(Function<? super L, ? extends T> lFunc, Function<? super R, ? extends T> rFunc) {
                return lFunc.apply(value);
            }
        };
    }

    public static <L, R> Either<L, R> right(final R value) {
        return new Either<L, R>(){

            @Override
            public <T> T map(Function<? super L, ? extends T> lFunc, Function<? super R, ? extends T> rFunc) {
                return rFunc.apply(value);
            }
        };
    }

    private Either() {
    }

    public abstract <T> T map(Function<? super L, ? extends T> var1, Function<? super R, ? extends T> var2);

    public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> lFunc) {
        return this.map(t -> Either.left(lFunc.apply((Object)t)), Either::right);
    }

    public <T> Either<L, T> mapRight(Function<? super R, ? extends T> lFunc) {
        return this.map(Either::left, t -> Either.right(lFunc.apply((Object)t)));
    }

    public <T> Either<T, R> flatMapLeft(Function<? super L, Either<T, R>> lFunc) {
        return this.map(lFunc, Either::right);
    }

    public <T> Either<L, T> flatMapRight(Function<? super R, Either<L, T>> rFunc) {
        return this.map(Either::left, rFunc);
    }

    public <R> R get() {
        return (R)this.map(l -> l, r -> r);
    }

    public Optional<L> getLeft() {
        return this.map(Optional::of, r -> Optional.empty());
    }

    public Optional<R> getRight() {
        return this.map(l -> Optional.empty(), Optional::of);
    }

    public void apply(Consumer<? super L> lFunc, Consumer<? super R> rFunc) {
        this.map(this.consume(lFunc), this.consume(rFunc));
    }

    private <T> Function<T, Void> consume(Consumer<T> c) {
        return t -> {
            c.accept(t);
            return null;
        };
    }
}

