/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.filter;

import java.util.Objects;
import oracle.pgx.api.filter.FilterType;
import oracle.pgx.api.filter.GraphFilter;

public final class PathFindingFilter
extends GraphFilter {
    private final GraphFilter graphFilter;
    private final Object sourceVertex;
    private final Object destinationVertex;

    public PathFindingFilter(GraphFilter graphFilter, Object sourceVertex, Object destinationVertex) {
        super(FilterType.PATH_FINDING);
        this.graphFilter = graphFilter;
        this.sourceVertex = sourceVertex;
        this.destinationVertex = destinationVertex;
    }

    public GraphFilter getGraphFilter() {
        return this.graphFilter;
    }

    public Object getSourceVertex() {
        return this.sourceVertex;
    }

    public Object getDestinationVertex() {
        return this.destinationVertex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathFindingFilter that = (PathFindingFilter)o;
        return Objects.equals(this.graphFilter, that.graphFilter) && Objects.equals(this.sourceVertex, that.sourceVertex) && Objects.equals(this.destinationVertex, that.destinationVertex);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.graphFilter, this.sourceVertex, this.destinationVertex);
    }

    public String toString() {
        return "PathFindingFilter(" + this.graphFilter + " src(" + this.sourceVertex + ") dst(" + this.destinationVertex + "))";
    }

    @Override
    public boolean isPathFindingFilter() {
        return true;
    }
}

