/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.AuthCertUtils;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.NameValidator;
import oracle.pgx.config.AbstractEngineConfig;
import oracle.pgx.config.AbstractEntityProviderConfigBuilder;
import oracle.pgx.config.AbstractFileGraphConfig;
import oracle.pgx.config.AbstractGraphConfigBuilder;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfig;
import oracle.pgx.config.FileGraphConfig;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.PartitionedGraphConfigBuilder;
import oracle.pgx.config.PgNosqlGraphConfig;
import oracle.pgx.config.RdbmsEntityProviderConfig;
import oracle.pgx.config.mllib.DbModelLoadingConfiguration;
import oracle.pgx.config.mllib.DbModelRepositoryConfiguration;
import oracle.pgx.config.mllib.DbModelStoringConfiguration;
import oracle.pgx.config.mllib.ModelLoadingConfiguration;
import oracle.pgx.config.mllib.ModelRepositoryConfiguration;
import oracle.pgx.config.mllib.ModelStoringConfiguration;
import oracle.pgx.vfs.PathSanitizerUtils;

public final class ConfigUtils {
    public static final String KEYSTORE_AS_STRING = "keystore_as_string";

    private ConfigUtils() {
    }

    public static void validateProperties(List<GraphPropertyConfig> propertyConfigs, boolean supportsVectorProperties, boolean supportsPropertyColumn, boolean supportsGraphProperties, String formatName) {
        HashSet<String> alreadyDefinedProperties = new HashSet<String>();
        for (GraphPropertyConfig propertyConfig : propertyConfigs) {
            String propName = propertyConfig.getName();
            NameValidator.validate((String[])new String[]{propName});
            if (alreadyDefinedProperties.contains(propName)) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PROPERTY_ALREADY_DEFINED_IN_CONFIG", (Object[])new Object[]{propName}));
            }
            alreadyDefinedProperties.add(propName);
            PropertyType type = propertyConfig.getType();
            if (propertyConfig.getDimension() > 0) {
                if (!supportsVectorProperties) {
                    throw new IllegalArgumentException(ErrorMessages.getMessage((String)"VECTOR_PROPERTIES_NOT_SUPPORTED", (Object[])new Object[]{formatName}));
                }
                ConfigUtils.validateVectorPropertyType(type, propertyConfig.getDimension());
            }
            if (!(supportsGraphProperties || type != PropertyType.VERTEX && type != PropertyType.EDGE)) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ENTITY_PROPERTIES_NOT_SUPPORTED_IN_TABLES", (Object[])new Object[]{type}));
            }
            if (propertyConfig.getColumn() == null) continue;
            if (!supportsPropertyColumn) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PROPERTY_COLUMN_NOT_SUPPORTED", (Object[])new Object[]{formatName}));
            }
            ConfigUtils.validatePropertyColumn(propertyConfig.getColumn());
        }
    }

    public static void validateVectorComponentDelimiter(boolean formatRequiresSeparator, String separator, Character vectorComponentDelimiter) {
        if (formatRequiresSeparator) {
            if (vectorComponentDelimiter == null) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{FileGraphConfig.Field.VECTOR_COMPONENT_DELIMITER.toKey()}));
            }
            if (separator.indexOf(vectorComponentDelimiter.charValue()) >= 0) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_COMPONENT_DELIMITER", (Object[])new Object[]{vectorComponentDelimiter, separator}));
            }
        }
    }

    public static void validateVectorPropertyType(PropertyType type, int dimension) {
        if (dimension > 0) {
            switch (type) {
                case INTEGER: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_TYPE", (Object[])new Object[]{type.toString()}));
                }
            }
        }
    }

    public static void validatePropertyColumn(Object column) {
        if (!(column instanceof String) && !(column instanceof Integer)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_PROPERTY_COLUMN_TYPE", (Object[])new Object[]{column.getClass().getName()}));
        }
    }

    public static String getKeyPropertyName(EntityProviderConfig tableConfig) {
        Object keyColumn = null;
        if (tableConfig instanceof RdbmsEntityProviderConfig) {
            keyColumn = ((RdbmsEntityProviderConfig)tableConfig).getKeyColumn();
        } else if (tableConfig instanceof FileEntityProviderConfig) {
            keyColumn = ((FileEntityProviderConfig)tableConfig).getKeyColumn();
        }
        if (keyColumn == null) {
            return null;
        }
        return ConfigUtils.mapKeyColumnIntoKeyProperty(tableConfig, keyColumn);
    }

    private static String mapKeyColumnIntoKeyProperty(EntityProviderConfig tableConfig, Object keyColumn) {
        String keyPropertyName = null;
        for (GraphPropertyConfig prop : tableConfig.getProps()) {
            Object propColumn = prop.getColumn();
            Object column = propColumn == null ? prop.getName() : propColumn;
            if (!column.equals(keyColumn)) continue;
            if (keyPropertyName == null) {
                keyPropertyName = prop.getName();
                continue;
            }
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"MULTIPLE_KEY_PROPERTIES_FOR_KEY_COLUMN", (Object[])new Object[]{column, tableConfig.getName()}));
        }
        return keyPropertyName;
    }

    public static GraphConfig createGraphConfigWithCredentials(GraphConfig config, String keystorePath, char[] keystorePassword) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        if (config == null) {
            return null;
        }
        if (config instanceof PartitionedGraphConfig) {
            return ConfigUtils.createPartitionedGraphConfigWithCredentials((PartitionedGraphConfig)config, keystorePath, keystorePassword);
        }
        String keystoreAlias = config.getKeystoreAlias();
        if (keystorePath == null || keystoreAlias == null) {
            return config;
        }
        AbstractGraphConfigBuilder builder = config.toGraphConfigBuilder();
        String password = AuthCertUtils.getPasswordFromKeystore((String)keystorePath, (char[])keystorePassword, (String)keystoreAlias);
        ConfigUtils.addKeystoreAsStringAttribute(config, builder, keystorePath, keystorePassword, keystoreAlias, password);
        return builder == null ? config : ((AbstractGraphConfigBuilder)builder.setPassword(password)).build();
    }

    private static void addKeystoreAsStringAttribute(GraphConfig config, AbstractGraphConfigBuilder builder, String keystorePath, char[] keystorePassword, String keystoreAlias, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        if (!(config instanceof PgNosqlGraphConfig) || builder == null) {
            return;
        }
        String keystoreAsStr = AuthCertUtils.getKeystoreAsString((String)keystorePath, (char[])keystorePassword, (String)password, (String[])new String[]{keystoreAlias});
        builder.addAttribute(KEYSTORE_AS_STRING, keystoreAsStr);
    }

    private static GraphConfig createPartitionedGraphConfigWithCredentials(PartitionedGraphConfig config, String keystorePath, char[] keystorePassword) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        PartitionedGraphConfigBuilder builder = config.toGraphConfigBuilder();
        if (keystorePath == null || builder == null) {
            return config;
        }
        builder.clearVertexProviders();
        builder.clearEdgeProviders();
        List<AbstractEntityProviderConfigBuilder> providerBuilders = ConfigUtils.updatedEntityProviderConfigList(config.getVertexProviders(), keystorePath, keystorePassword);
        for (AbstractEntityProviderConfigBuilder providerBuilder : providerBuilders) {
            builder.addVertexProvider(providerBuilder);
        }
        providerBuilders = ConfigUtils.updatedEntityProviderConfigList(config.getEdgeProviders(), keystorePath, keystorePassword);
        for (AbstractEntityProviderConfigBuilder providerBuilder : providerBuilders) {
            builder.addEdgeProvider(providerBuilder);
        }
        String keystoreAlias = config.getKeystoreAlias();
        if (keystoreAlias == null) {
            return builder.build();
        }
        String password = AuthCertUtils.getPasswordFromKeystore((String)keystorePath, (char[])keystorePassword, (String)keystoreAlias);
        return ((PartitionedGraphConfigBuilder)builder.setPassword(password)).build();
    }

    private static List<AbstractEntityProviderConfigBuilder> updatedEntityProviderConfigList(List<EntityProviderConfig> providers, String keystorePath, char[] keystorePassword) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        ArrayList<AbstractEntityProviderConfigBuilder> updatedProviders = new ArrayList<AbstractEntityProviderConfigBuilder>();
        for (EntityProviderConfig provider : providers) {
            EntityProviderConfig updatedProvider = ConfigUtils.createProviderConfigWithCredentials(keystorePath, keystorePassword, provider);
            updatedProviders.add(updatedProvider.toEntityProviderConfigBuilder());
        }
        return updatedProviders;
    }

    public static EntityProviderConfig createProviderConfigWithCredentials(String keystorePath, char[] keystorePassword, EntityProviderConfig provider) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        if (keystorePath == null || keystorePassword == null) {
            return provider;
        }
        String keystoreAlias = provider.getKeystoreAlias();
        AbstractEntityProviderConfigBuilder updatedProvider = provider.toEntityProviderConfigBuilder();
        if (keystoreAlias != null) {
            String password = AuthCertUtils.getPasswordFromKeystore((String)keystorePath, (char[])keystorePassword, (String)keystoreAlias);
            updatedProvider.setPassword(password);
        }
        return updatedProvider.build();
    }

    public static void modifyModelLoadingConfigWithCredentials(String keystorePath, char[] keystorePassword, ModelLoadingConfiguration config) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        if (!(config instanceof DbModelLoadingConfiguration)) {
            return;
        }
        DbModelLoadingConfiguration dbModelLoadingConfiguration = (DbModelLoadingConfiguration)config;
        String keystoreAlias = dbModelLoadingConfiguration.getKeystoreAlias();
        if (keystoreAlias != null) {
            String password = AuthCertUtils.getPasswordFromKeystore((String)keystorePath, (char[])keystorePassword, (String)keystoreAlias);
            dbModelLoadingConfiguration.setPassword(password);
            dbModelLoadingConfiguration.setKeystoreAlias(null);
        }
    }

    public static void modifyModelStoringConfigWithCredentials(String keystorePath, char[] keystorePassword, ModelStoringConfiguration config) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        if (!(config instanceof DbModelStoringConfiguration)) {
            return;
        }
        DbModelStoringConfiguration dbModelStoringConfiguration = (DbModelStoringConfiguration)config;
        String keystoreAlias = dbModelStoringConfiguration.getKeystoreAlias();
        if (keystoreAlias != null) {
            String password = AuthCertUtils.getPasswordFromKeystore((String)keystorePath, (char[])keystorePassword, (String)keystoreAlias);
            dbModelStoringConfiguration.setPassword(password);
            dbModelStoringConfiguration.setKeystoreAlias(null);
        }
    }

    public static void modifyModelRepositoryConfigWithCredentials(String keystorePath, char[] keystorePassword, ModelRepositoryConfiguration config) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        if (!(config instanceof DbModelRepositoryConfiguration)) {
            return;
        }
        DbModelRepositoryConfiguration dbModelRepositoryConfiguration = (DbModelRepositoryConfiguration)config;
        String keystoreAlias = dbModelRepositoryConfiguration.getKeystoreAlias();
        if (keystoreAlias != null) {
            String password = AuthCertUtils.getPasswordFromKeystore((String)keystorePath, (char[])keystorePassword, (String)keystoreAlias);
            dbModelRepositoryConfiguration.setPassword(password);
            dbModelRepositoryConfiguration.setKeystoreAlias(null);
        }
    }

    public static GraphConfig createGraphConfigWithoutCredentials(GraphConfig config) {
        if (config == null) {
            return null;
        }
        if (config instanceof PartitionedGraphConfig) {
            return ConfigUtils.createPartitionedGraphConfigWithoutCredentials((PartitionedGraphConfig)config);
        }
        AbstractGraphConfigBuilder builder = config.toGraphConfigBuilder();
        builder.redactPassword();
        return builder.build();
    }

    private static GraphConfig createPartitionedGraphConfigWithoutCredentials(PartitionedGraphConfig config) {
        PartitionedGraphConfigBuilder builder = config.toGraphConfigBuilder();
        if (builder == null) {
            return config;
        }
        builder.setVertexProviders(ConfigUtils.updatedEntityProviderConfigList(config.getVertexProviders()));
        builder.setEdgeProviders(ConfigUtils.updatedEntityProviderConfigList(config.getEdgeProviders()));
        builder.redactPassword();
        return builder.build();
    }

    private static List<EntityProviderConfig> updatedEntityProviderConfigList(List<EntityProviderConfig> providers) {
        ArrayList<EntityProviderConfig> updatedProviders = new ArrayList<EntityProviderConfig>();
        for (EntityProviderConfig provider : providers) {
            EntityProviderConfig updatedProvider = ConfigUtils.createEntityProviderConfigWithoutCredentials(provider);
            updatedProviders.add(updatedProvider);
        }
        return updatedProviders;
    }

    public static EntityProviderConfig createEntityProviderConfigWithoutCredentials(EntityProviderConfig provider) {
        AbstractEntityProviderConfigBuilder builder = provider.toEntityProviderConfigBuilder();
        builder.redactPassword();
        return builder.build();
    }

    public static Optional<IllegalArgumentException> sanitizeUris(GraphConfig config, AbstractEngineConfig pgxConfig) {
        List<String> uris = null;
        if (config instanceof PartitionedGraphConfig) {
            uris = PathSanitizerUtils.getUris((PartitionedGraphConfig)config);
        } else if (AbstractFileGraphConfig.class.isAssignableFrom(config.getClass())) {
            uris = PathSanitizerUtils.getUris((AbstractFileGraphConfig)config);
        }
        Optional<IllegalArgumentException> result = Optional.empty();
        if (uris != null) {
            result = PathSanitizerUtils.checkIfFileSystemAllowsRemoteLoading(pgxConfig, uris);
        }
        return result;
    }
}

