/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.UdfFunctionConfig;
import oracle.pgx.config.UdfLanguage;

public final class UdfFunctionConfigBuilder {
    private final Map<UdfFunctionConfig.Field, Object> values = new HashMap<UdfFunctionConfig.Field, Object>();

    public static UdfFunctionConfig buildUdfFunctionConfig(Consumer<UdfFunctionConfigBuilder> builderSetup) {
        UdfFunctionConfigBuilder builder = new UdfFunctionConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public UdfFunctionConfigBuilder() {
    }

    public UdfFunctionConfigBuilder(Map<UdfFunctionConfig.Field, Object> values) {
        this.putAll(values);
    }

    public UdfFunctionConfigBuilder(UdfFunctionConfig config) {
        this.putAll(config);
    }

    public UdfFunctionConfigBuilder(UdfFunctionConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public UdfFunctionConfigBuilder putAll(Map<UdfFunctionConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public UdfFunctionConfigBuilder putAll(UdfFunctionConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public UdfFunctionConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public UdfFunctionConfig build(String parentPath) {
        try {
            return UdfFunctionConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public UdfFunctionConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<UdfFunctionConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "UdfFunctionConfigBuilder" + this.values;
    }

    public UdfFunctionConfigBuilder setNamespace(String namespace) {
        this.values.put(UdfFunctionConfig.Field.NAMESPACE, namespace);
        return this;
    }

    public UdfFunctionConfigBuilder setFunctionName(String functionName) {
        this.values.put(UdfFunctionConfig.Field.FUNCTION_NAME, functionName);
        return this;
    }

    public UdfFunctionConfigBuilder setLanguage(UdfLanguage language) {
        this.values.put(UdfFunctionConfig.Field.LANGUAGE, (Object)language);
        return this;
    }

    public UdfFunctionConfigBuilder setSourceLocation(String sourceLocation) {
        this.values.put(UdfFunctionConfig.Field.SOURCE_LOCATION, sourceLocation);
        return this;
    }

    public UdfFunctionConfigBuilder setSourceCode(String sourceCode) {
        this.values.put(UdfFunctionConfig.Field.SOURCE_CODE, sourceCode);
        return this;
    }

    public UdfFunctionConfigBuilder setImplementationReference(String implementationReference) {
        this.values.put(UdfFunctionConfig.Field.IMPLEMENTATION_REFERENCE, implementationReference);
        return this;
    }

    public UdfFunctionConfigBuilder setSourceFunctionName(String sourceFunctionName) {
        this.values.put(UdfFunctionConfig.Field.SOURCE_FUNCTION_NAME, sourceFunctionName);
        return this;
    }

    public UdfFunctionConfigBuilder setReturnType(PropertyType returnType) {
        this.values.put(UdfFunctionConfig.Field.RETURN_TYPE, returnType);
        return this;
    }

    public UdfFunctionConfigBuilder setArguments(Object ... arguments) {
        this.values.put(UdfFunctionConfig.Field.ARGUMENTS, arguments);
        return this;
    }

    public UdfFunctionConfigBuilder setArguments(List<?> arguments) {
        this.values.put(UdfFunctionConfig.Field.ARGUMENTS, arguments);
        return this;
    }
}

