/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.List;
import java.util.concurrent.TimeUnit;
import oracle.pgx.config.AbstractGraphConfigFactory;
import oracle.pgx.config.AbstractPgGraphConfigBuilder;
import oracle.pgx.config.DbEngine;
import oracle.pgx.config.PgNosqlGraphConfig;
import oracle.pgx.config.PgNosqlGraphConfigFactory;
import oracle.pgx.config.internal.ConfigBuilderWithPassword;

public class PgNosqlGraphConfigBuilder
extends AbstractPgGraphConfigBuilder<PgNosqlGraphConfigBuilder, PgNosqlGraphConfig>
implements ConfigBuilderWithPassword<PgNosqlGraphConfigBuilder> {
    public PgNosqlGraphConfigBuilder() {
        this.setDbEngine(DbEngine.NOSQL);
    }

    @Override
    protected AbstractGraphConfigFactory<PgNosqlGraphConfig> getFactory() {
        return new PgNosqlGraphConfigFactory(true, true);
    }

    @Override
    public PgNosqlGraphConfigBuilder copyFrom(PgNosqlGraphConfig graphConfig) {
        super.copyFrom(graphConfig);
        this.setHosts(graphConfig.getHosts());
        this.setStoreName(graphConfig.getStoreName());
        this.setRequestTimeout(graphConfig.getRequestTimeoutMs().intValue(), TimeUnit.MILLISECONDS);
        this.setUsername(graphConfig.getUsername());
        this.setKeystoreAlias(graphConfig.getKeystoreAlias());
        return (PgNosqlGraphConfigBuilder)this.getThis();
    }

    public PgNosqlGraphConfigBuilder setHosts(List<String> hosts) {
        this.values.put(PgNosqlGraphConfig.Field.HOSTS.toKey(), hosts);
        return this;
    }

    public PgNosqlGraphConfigBuilder setStoreName(String storeName) {
        this.values.put(PgNosqlGraphConfig.Field.STORE_NAME.toKey(), storeName);
        return this;
    }

    public PgNosqlGraphConfigBuilder setRequestTimeout(long timeout, TimeUnit unit) {
        this.values.put(PgNosqlGraphConfig.Field.REQUEST_TIMEOUT_MS.toKey(), unit.toMillis(timeout));
        return this;
    }

    public PgNosqlGraphConfigBuilder setUsername(String u) {
        this.values.put(PgNosqlGraphConfig.Field.USERNAME.toKey(), u);
        return this;
    }

    @Override
    public PgNosqlGraphConfigBuilder setPassword(String p) {
        this.values.put(PgNosqlGraphConfig.Field.PASSWORD.toKey(), p);
        return this;
    }

    @Override
    public PgNosqlGraphConfigBuilder setKeystoreAlias(String keystoreAlias) {
        this.values.put(PgNosqlGraphConfig.Field.KEYSTORE_ALIAS.toKey(), keystoreAlias);
        return this;
    }
}

