/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.FileGraphStoringConfig;
import oracle.pgx.vfs.CompressionScheme;

public final class FileGraphStoringConfigBuilder {
    private final Map<String, Object> values = new HashMap<String, Object>();

    public FileGraphStoringConfigBuilder() {
    }

    public FileGraphStoringConfigBuilder(String basePath) {
        this.setBasePath(basePath);
    }

    public FileGraphStoringConfig build() {
        FileGraphStoringConfig fileGraphStoringConfig;
        ByteArrayInputStream is = new ByteArrayInputStream(ConfigJsonUtil.writeValueAsBytes(this.values));
        try {
            fileGraphStoringConfig = FileGraphStoringConfig.parse(is, true, null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        ((InputStream)is).close();
        return fileGraphStoringConfig;
    }

    public FileGraphStoringConfigBuilder setInitialPartitionIndex(int initialPartitionIndex) {
        this.values.put(FileGraphStoringConfig.Field.INITIAL_PARTITION_INDEX.toKey(), initialPartitionIndex);
        return this;
    }

    public FileGraphStoringConfigBuilder setVertexExtension(String vertexExtension) {
        this.values.put(FileGraphStoringConfig.Field.VERTEX_EXTENSION.toKey(), vertexExtension);
        return this;
    }

    public FileGraphStoringConfigBuilder setEdgeExtension(String edgeExtension) {
        this.values.put(FileGraphStoringConfig.Field.EDGE_EXTENSION.toKey(), edgeExtension);
        return this;
    }

    public FileGraphStoringConfigBuilder setRowExtension(String rowExtension) {
        this.values.put(FileGraphStoringConfig.Field.ROW_EXTENSION.toKey(), rowExtension);
        return this;
    }

    public FileGraphStoringConfigBuilder setBasePath(String basePath) {
        this.values.put(FileGraphStoringConfig.Field.BASE_PATH.toKey(), basePath);
        return this;
    }

    public FileGraphStoringConfigBuilder setNumPartitions(int numPartitions) {
        this.values.put(FileGraphStoringConfig.Field.NUM_PARTITIONS.toKey(), numPartitions);
        return this;
    }

    public FileGraphStoringConfigBuilder setDelimiter(char delimiter) {
        this.values.put(FileGraphStoringConfig.Field.DELIMITER.toKey(), Character.valueOf(delimiter));
        return this;
    }

    public FileGraphStoringConfigBuilder setCompressionScheme(CompressionScheme scheme) {
        this.values.put(FileGraphStoringConfig.Field.COMPRESSION_SCHEME.toKey(), scheme);
        return this;
    }
}

