/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.List;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.UdfFunctionArgumentConfig;
import oracle.pgx.config.UdfFunctionConfig;
import oracle.pgx.config.UdfLanguage;

public abstract class AbstractUdfFunctionConfig
extends AbstractConfig {
    public abstract String getFunctionName();

    public abstract UdfLanguage getLanguage();

    public abstract String getSourceLocation();

    public abstract String getSourceCode();

    public abstract String getImplementationReference();

    public abstract String getSourceFunctionName();

    public abstract PropertyType getReturnType();

    public abstract List<UdfFunctionArgumentConfig> getArguments();

    @Override
    protected void validate() {
        super.validate();
        this.validateHasSourceOrSourceUri();
        this.validateTypes();
    }

    private void validateHasSourceOrSourceUri() {
        if (this.getSourceLocation() == null && this.getSourceCode() == null && this.getImplementationReference() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXCLUSIVE_ARGUMENT_IS_REQUIRED", (Object[])new Object[]{UdfFunctionConfig.Field.SOURCE_LOCATION.toKey(), UdfFunctionConfig.Field.SOURCE_CODE.toKey()}));
        }
        if (this.getSourceLocation() != null && this.getSourceCode() != null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{UdfFunctionConfig.Field.SOURCE_LOCATION.toKey(), UdfFunctionConfig.Field.SOURCE_CODE.toKey()}));
        }
    }

    private void validateType(PropertyType type, String errorMessage) {
        switch (type) {
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case STRING: {
                break;
            }
            default: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)errorMessage, (Object[])new Object[]{type}));
            }
        }
    }

    private void validateTypes() {
        this.validateType(this.getReturnType(), "USER_DEFINED_FUNCTION_UNSUPPORTED_RETURN_TYPE");
        this.getArguments().stream().map(UdfFunctionArgumentConfig::getType).forEach(type -> this.validateType((PropertyType)type, "USER_DEFINED_FUNCTION_UNSUPPORTED_ARGUMENT_TYPE"));
    }
}

