/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import oracle.pgx.config.AbstractPgGraphConfig;
import oracle.pgx.config.PgNosqlGraphConfig;
import oracle.pgx.config.PgNosqlGraphConfigBuilder;

abstract class AbstractPgNosqlGraphConfig
extends AbstractPgGraphConfig {
    AbstractPgNosqlGraphConfig() {
    }

    @Override
    public PgNosqlGraphConfigBuilder toGraphConfigBuilder() {
        return new PgNosqlGraphConfigBuilder().copyFrom((PgNosqlGraphConfig)this);
    }

    abstract List<String> getHosts();

    abstract String getStoreName();

    @Override
    protected void validate() {
        super.validate();
        if (this.getHosts() == null || this.getHosts().isEmpty()) {
            throw new IllegalArgumentException("must specify at least one host");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPgNosqlGraphConfig that = (AbstractPgNosqlGraphConfig)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.getHosts(), that.getHosts())) {
            return false;
        }
        return Objects.equals(this.getStoreName(), that.getStoreName());
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code += new HashSet<String>(this.getHosts()).hashCode();
        return code += this.getStoreName().hashCode();
    }
}

