/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.api.internal.PropertyValue;
import oracle.pgx.api.internal.ScalarValue;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.internal.EntityDeserializationHelper;

public class ValueMarshaler<T extends ScalarValue<?>>
implements Marshaler<T> {
    @Override
    public String marshal(T object) throws IOException {
        return JsonUtil.toJson(object);
    }

    @Override
    public T unmarshal(String content) throws IOException {
        String sanitizedContent = JsonUtil.sanitize((String)content);
        PropertyValue propertyValue = (PropertyValue)((Object)JsonUtil.readValue((String)sanitizedContent, PropertyValue.class));
        JsonNode node = (JsonNode)JsonUtil.readValue((String)sanitizedContent, JsonNode.class);
        JsonNode isValueWrappedNode = node.get("valueWrapped");
        boolean isWrapped = false;
        if (isValueWrappedNode != null) {
            isWrapped = Boolean.TRUE.equals(JsonUtil.fromJsonNode((JsonNode)isValueWrappedNode, Boolean.class));
        }
        String stringValue = node.findValue("value").toString();
        Object value = isWrapped ? EntityDeserializationHelper.deserializeEntityOrKey((JsonNode)JsonUtil.readTopLevelJsonToTree((String)stringValue)).getLeft().get() : JsonUtil.readValue((String)stringValue, propertyValue.getTypeClass());
        propertyValue.setValue(value);
        return (T)((Object)propertyValue);
    }
}

