/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Base64;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.util.JsonUtil;

public class BytesMarshaler
implements Marshaler<byte[]> {
    @Override
    public byte[] unmarshal(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        JsonNode node = JsonUtil.readTopLevelJsonToTree((String)jsonString);
        String base64Encoded = (String)JsonUtil.fromJsonNode((JsonNode)node.get("entity"), String.class);
        return Base64.getDecoder().decode(base64Encoded);
    }

    @Override
    public String marshal(byte[] object) throws JsonGenerationException, JsonMappingException, IOException {
        return JsonUtil.toJson((Object)Base64.getEncoder().encodeToString(object));
    }
}

