/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.mllib.GenericModelStorer;
import oracle.pgx.config.mllib.ModelKind;

public abstract class Model<ModelType extends Model<ModelType>>
implements AutoCloseable {
    protected final PgxSession session;
    protected final Core core;
    protected final Supplier<String> keystorePathSupplier;
    protected final Supplier<char[]> keystorePasswordSupplier;

    public Model(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
    }

    protected abstract ModelType getThis();

    protected abstract ModelKind getModelKind();

    abstract String getModelName();

    public GenericModelStorer<ModelType> export() {
        return new GenericModelStorer<ModelType>(this.session, this.core, this.getThis(), this.keystorePathSupplier, this.keystorePasswordSupplier);
    }

    public abstract PgxFuture<Void> destroyAsync();

    @Override
    public void close() {
        this.destroyAsync().join();
    }
}

