/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.ActivationFunction;
import oracle.pgx.config.mllib.GraphWiseBaseConvLayerConfig;
import oracle.pgx.config.mllib.WeightInitScheme;

public abstract class GraphWiseBaseConvLayerConfigBuilder<Config extends GraphWiseBaseConvLayerConfig, Self extends GraphWiseBaseConvLayerConfigBuilder> {
    protected Config layerConfig;

    protected abstract Self getThis();

    public Self setNumSampledNeighbors(int numSampledNeighbors) {
        this.layerConfig.setNumSampledNeighbors(numSampledNeighbors);
        return this.getThis();
    }

    public Self setActivationFunction(ActivationFunction activationFunction) {
        this.layerConfig.setActivationFunction(activationFunction);
        return this.getThis();
    }

    public Self setWeightInitScheme(WeightInitScheme weightInitScheme) {
        this.layerConfig.setWeightInitScheme(weightInitScheme);
        return this.getThis();
    }

    public Self setDropoutRate(double dropoutRate) {
        this.layerConfig.setDropoutRate(dropoutRate);
        return this.getThis();
    }

    protected void validateDropoutRate() {
        if (this.layerConfig.getDropoutRate() < 0.0 || this.layerConfig.getDropoutRate() >= 1.0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_DROPOUT_RATE", (Object[])new Object[]{this.layerConfig.getDropoutRate()}));
        }
    }

    public Self useVertexToEdgeConnection(boolean vertexToEdgeConnection) {
        this.layerConfig.useVertexToEdgeConnection(vertexToEdgeConnection);
        return this.getThis();
    }

    public Self useVertexToVertexConnection(boolean vertexToVertexConnection) {
        this.layerConfig.useVertexToVertexConnection(vertexToVertexConnection);
        return this.getThis();
    }

    public Self useEdgeToVertexConnection(boolean edgeToVertexConnection) {
        this.layerConfig.useEdgeToVertexConnection(edgeToVertexConnection);
        return this.getThis();
    }

    public Self useEdgeToEdgeConnection(boolean edgeToEdgeConnection) {
        this.layerConfig.useEdgeToEdgeConnection(edgeToEdgeConnection);
        return this.getThis();
    }
}

