/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.function.Supplier;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.mllib.AbstractModelRepositoryBuilder;
import oracle.pgx.api.mllib.DbModelRepository;
import oracle.pgx.config.mllib.DbModelRepositoryConfiguration;

public class DbModelRepositoryBuilder
extends AbstractModelRepositoryBuilder {
    private final DbModelRepositoryConfiguration modelRepositoryConfiguration = new DbModelRepositoryConfiguration();

    public DbModelRepositoryBuilder(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier);
    }

    protected DbModelRepositoryBuilder getThis() {
        return this;
    }

    public DbModelRepositoryBuilder owner(String owner) {
        this.modelRepositoryConfiguration.setOwner(owner);
        return this.getThis();
    }

    public DbModelRepositoryBuilder schema(String schema) {
        return this.owner(schema);
    }

    public DbModelRepositoryBuilder dataSourceId(String dataSourceId) {
        this.modelRepositoryConfiguration.setDataSourceId(dataSourceId);
        return this.getThis();
    }

    public DbModelRepositoryBuilder jdbcUrl(String jdbcUrl) {
        this.modelRepositoryConfiguration.setJdbcUrl(jdbcUrl);
        return this.getThis();
    }

    public DbModelRepositoryBuilder username(String username) {
        this.modelRepositoryConfiguration.setUsername(username);
        return this.getThis();
    }

    public DbModelRepositoryBuilder password(String password) {
        this.modelRepositoryConfiguration.setPassword(password);
        return this.getThis();
    }

    public DbModelRepositoryBuilder keystoreAlias(String keystore) {
        this.modelRepositoryConfiguration.setKeystoreAlias(keystore);
        return this.getThis();
    }

    public DbModelRepository open() {
        return new DbModelRepository(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier, this.modelRepositoryConfiguration);
    }
}

