/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.io.IOException;
import java.io.Serializable;
import oracle.pgx.api.internal.PropertyProxyInfo;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.Direction;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.util.SerializationHelper;

public class PgqlRedactionArgument
implements Serializable {
    private PgxId graphId;
    private boolean noHopQuery;
    private boolean oneHopQuery;
    private Direction direction;
    private String proxyUuid;
    private String propId;
    private SelectionType selectionType;
    private String filterValue;
    private boolean filterOnSource;
    private boolean filterOnEdge;
    private boolean orderBy;
    private boolean orderByIdsOnly;
    private boolean ascending;
    private long limit;
    private long offset;
    private String propName;
    private boolean skipQuery;

    private PgqlRedactionArgument(PgxId graphId, boolean noHopQuery, boolean oneHopQuery, Direction direction, String proxyUuid, String propId, SelectionType selectionType, String filterValue, boolean filterOnSource, boolean filterOnEdge, boolean orderBy, boolean orderByIdsOnly, boolean ascending, long limit, long offset) {
        this.graphId = graphId;
        this.noHopQuery = noHopQuery;
        this.oneHopQuery = oneHopQuery;
        this.direction = direction;
        this.proxyUuid = proxyUuid;
        this.propId = propId;
        this.selectionType = selectionType;
        this.filterValue = filterValue;
        this.filterOnSource = filterOnSource;
        this.filterOnEdge = filterOnEdge;
        this.orderBy = orderBy;
        this.orderByIdsOnly = orderByIdsOnly;
        this.ascending = ascending;
        this.limit = limit;
        this.offset = offset;
        this.skipQuery = false;
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setPropName(String propName) {
        assert (this.proxyUuid != null || this.propId != null);
        this.propName = propName;
    }

    public void setSelectionType(SelectionType selectionType) {
        this.selectionType = selectionType;
    }

    public void setShouldSkipQuery() {
        this.skipQuery = true;
    }

    public PgxId getGraphId() {
        return this.graphId;
    }

    public boolean isNoHopQuery() {
        return this.noHopQuery;
    }

    public String getProxyUuid() {
        return this.proxyUuid;
    }

    public String getPropId() {
        return this.propId;
    }

    public String getPropName() {
        return this.propName;
    }

    public boolean shouldSkipQuery() {
        return this.skipQuery;
    }

    public static String generateQueryFromSerializedArgument(String str, boolean isVertexEntityType, String propName, boolean hasStringVertexKey, boolean hasStringEdgeKey) {
        try {
            PgqlRedactionArgument arg = (PgqlRedactionArgument)SerializationHelper.deserializeObject((String)str);
            arg.updateFromEntityType(isVertexEntityType ? EntityType.VERTEX : EntityType.EDGE);
            arg.setPropName(propName);
            return arg.generateQuery(hasStringVertexKey, hasStringEdgeKey);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void updateFromPropertyProxyInfo(PropertyProxyInfo propertyProxyInfo) {
        this.graphId = propertyProxyInfo.getGraphId();
        this.updateFromEntityType(propertyProxyInfo.getEntityType());
    }

    private void updateFromEntityType(EntityType entityType) {
        if (entityType == EntityType.VERTEX) {
            this.noHopQuery = true;
            this.filterOnSource = true;
        } else {
            this.oneHopQuery = true;
            this.filterOnEdge = true;
        }
    }

    public String generateQuery(boolean hasStringVertexKey, boolean hasStringEdgeKey) {
        String query = "SELECT ";
        switch (this.selectionType) {
            case ID: {
                query = query + "id(v)";
                break;
            }
            case EDGE_ID: {
                query = query + "id(e)";
                break;
            }
            case DEST_ID: {
                query = query + "id(w)";
                break;
            }
            case LABEL: {
                query = query + "label(e)";
                break;
            }
            case LABELS: {
                query = query + "labels(v)";
                break;
            }
            case PROPERTY: {
                if (this.noHopQuery) {
                    query = query + "v.\"" + this.propName + "\"";
                    break;
                }
                query = query + "e.\"" + this.propName + "\"";
                break;
            }
            case ID_AND_PROPERTY: {
                if (this.noHopQuery) {
                    query = query + "id(v), v.\"" + this.propName + "\" AS prop";
                    break;
                }
                query = query + "id(e), e.\"" + this.propName + "\" AS prop";
                break;
            }
            default: {
                throw new RuntimeException("Missing case for selection type");
            }
        }
        query = query + " MATCH ";
        if (this.noHopQuery) {
            query = query + "(v)";
        } else {
            query = query + "(v)";
            switch (this.direction) {
                case OUTGOING: {
                    query = query + "-[e]->";
                    break;
                }
                case INCOMING: {
                    query = query + "<-[e]-";
                    break;
                }
                case BOTH: {
                    query = query + "-[e]-";
                    break;
                }
                default: {
                    throw new RuntimeException("Missing case for direction");
                }
            }
            query = query + "(w)";
        }
        if (this.filterValue != null) {
            query = query + " WHERE ";
            if (this.noHopQuery || this.filterOnSource) {
                query = query + "id(v) = ";
                query = hasStringVertexKey ? query + "'" + this.filterValue + "'" : query + this.filterValue;
            } else {
                assert (this.filterOnEdge);
                query = query + "id(e) = ";
                query = hasStringEdgeKey ? query + "'" + this.filterValue + "'" : query + this.filterValue;
            }
        }
        if (this.orderBy) {
            assert (this.selectionType == SelectionType.ID_AND_PROPERTY);
            query = query + " ORDER BY ";
            if (!this.orderByIdsOnly) {
                query = query + "prop, ";
            }
            query = this.noHopQuery ? query + "id(v) " : query + "id(e) ";
            query = this.ascending ? query + "ASC" : query + "DESC";
            query = query + " LIMIT " + this.limit + " OFFSET " + this.offset;
        }
        return query;
    }

    public static class Builder {
        private PgxId graphId;
        private boolean noHopQuery = false;
        private boolean oneHopQuery = false;
        private Direction direction;
        private String proxyUuid;
        private String propId;
        private SelectionType selectionType;
        private String filterValue;
        private boolean filterOnSource = false;
        private boolean filterOnEdge = false;
        private boolean orderBy = false;
        private boolean orderByIdsOnly = false;
        private boolean ascending;
        private long limit = 0L;
        private long offset = 0L;

        public Builder setGraphId(PgxId graphId) {
            this.graphId = graphId;
            return this;
        }

        public Builder setIsNoHopQuery() {
            this.noHopQuery = true;
            return this;
        }

        public Builder setIsOneHopQuery() {
            this.oneHopQuery = true;
            return this;
        }

        public Builder setDirection(Direction direction) {
            this.direction = direction;
            return this;
        }

        public Builder setProxyUuid(String proxyUuid) {
            this.proxyUuid = proxyUuid;
            return this;
        }

        public Builder setPropId(String propId) {
            this.propId = propId;
            return this;
        }

        public Builder setSelectionType(SelectionType selectionType) {
            this.selectionType = selectionType;
            return this;
        }

        public Builder setFilterValue(String filterValue) {
            this.filterValue = filterValue;
            return this;
        }

        public Builder setFilterOnSource() {
            this.filterOnSource = true;
            return this;
        }

        public Builder setFilterOnEdge() {
            this.filterOnEdge = true;
            return this;
        }

        public Builder setOrderBy(boolean ascending, boolean orderByIdsOnly, long limit, long offset) {
            this.orderBy = true;
            this.orderByIdsOnly = orderByIdsOnly;
            this.ascending = ascending;
            this.limit = limit;
            this.offset = offset;
            return this;
        }

        public PgqlRedactionArgument build() {
            if (this.proxyUuid != null && (this.noHopQuery || this.oneHopQuery)) {
                throw new IllegalArgumentException("The proxy cannot be set while the number of hops is set");
            }
            if (this.proxyUuid == null && this.noHopQuery == this.oneHopQuery) {
                throw new IllegalArgumentException("The number of hops must be specified exactly once");
            }
            if (this.filterOnSource && this.filterOnEdge) {
                throw new IllegalArgumentException("There must be at most one filter");
            }
            if (this.filterValue != null && this.oneHopQuery && !this.filterOnSource && !this.filterOnEdge) {
                throw new IllegalArgumentException("When filtering with one hop, either filterOnSource or filterOnEdge must be set");
            }
            if (this.oneHopQuery && this.direction == null) {
                throw new IllegalArgumentException("With one hop queries, direction must be set");
            }
            return new PgqlRedactionArgument(this.graphId, this.noHopQuery, this.oneHopQuery, this.direction, this.proxyUuid, this.propId, this.selectionType, this.filterValue, this.filterOnSource, this.filterOnEdge, this.orderBy, this.orderByIdsOnly, this.ascending, this.limit, this.offset);
        }
    }

    public static enum SelectionType {
        ID,
        EDGE_ID,
        DEST_ID,
        LABEL,
        LABELS,
        PROPERTY,
        ID_AND_PROPERTY;

    }
}

