/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import oracle.pgx.api.EdgeProperty;
import oracle.pgx.api.VertexProperty;
import oracle.pgx.api.internal.EntityTable;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.Property;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.FileGraphConfig;
import oracle.pgx.config.FileGraphConfigBuilder;
import oracle.pgx.config.FileGraphStoringConfig;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphConfigBuilder;

public class GraphConfigGenerationHelper {
    public static Integer getKeyColumnIndex(EntityTable table) {
        if (table.getKeyPropertyName() == null) {
            return null;
        }
        int oneBasedIndex = 1;
        LinkedHashMap<PgxId, Property> properties = table.getProperties();
        for (Property property : properties.values()) {
            if (property.getName().equals(table.getKeyPropertyName())) {
                if (table.getEntityType() == EntityType.EDGE) {
                    return oneBasedIndex + 2;
                }
                return oneBasedIndex;
            }
            ++oneBasedIndex;
        }
        return null;
    }

    public static String getLabelFromProvider(String name, EntityTable table) {
        Set<String> labels = table.getProviderLabels();
        int numLabels = labels.size();
        if (numLabels > 1) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"PROVIDER_HAS_MULTIPLE_LABELS", (Object[])new Object[]{name}));
        }
        String label = numLabels == 1 ? labels.iterator().next() : null;
        return label;
    }

    public static FileGraphConfig generateFileGraphConfig(Format targetFormat, String targetPath, FileGraphStoringConfig storingConfig, Graph graph, IdType vertexIdType, Collection<VertexProperty<?, ?>> vertexProperties, Collection<EdgeProperty<?>> edgeProperties) {
        FileGraphConfigBuilder builder = GraphConfigBuilder.forFileFormat((Format)targetFormat);
        builder.setVertexIdType(vertexIdType);
        builder.setVertexUris(new String[]{targetPath});
        builder.setStoringOptions(storingConfig);
        for (VertexProperty<?, ?> vertexProperty : vertexProperties) {
            builder.addVertexVectorProperty(vertexProperty.getName(), vertexProperty.getType(), vertexProperty.getDimension(), null);
        }
        for (EdgeProperty edgeProperty : edgeProperties) {
            builder.addEdgeVectorProperty(edgeProperty.getName(), edgeProperty.getType(), edgeProperty.getDimension(), null);
        }
        if (targetFormat.hasVerticesAndEdgesSeparatedFileFormat()) {
            builder.setEdgeUris(new String[]{targetPath});
        }
        if (graph.getVertexLabels() != null) {
            builder.setLoadVertexLabels(true);
        }
        if (graph.getEdgeLabel() != null) {
            builder.setLoadEdgeLabel(true);
        }
        if (targetFormat == Format.CSV) {
            builder.setPropertyValueDelimiter(":");
        }
        return (FileGraphConfig)builder.build();
    }
}

