/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import oracle.pgx.api.internal.EdgeChanges;
import oracle.pgx.api.internal.ElementChanges;
import oracle.pgx.api.internal.VertexChanges;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.MutableLong;
import oracle.pgx.common.types.ChangeType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ChangeTrackingMap;
import oracle.pgx.common.util.EntityIdConversionHelper;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.InvalidChangeHandler;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.function.ConsumerWithException;
import oracle.pgx.config.OnAddExistingElement;
import oracle.pgx.config.OnInvalidChange;
import oracle.pgx.config.OnRequiredConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Changes<VID> {
    private static final Logger LOG = LoggerFactory.getLogger(Changes.class);
    private final IdType idType;
    private final ChangesIntent intent;
    private final ChangeTrackingMap<VID, VertexChanges> vertexChangesMap = new ChangeTrackingMap();
    private final ChangeTrackingMap<Object, EdgeChanges> edgeChangesMap = new ChangeTrackingMap();
    private final Map<String, PropertyType> vertexPropTypes = new HashMap<String, PropertyType>();
    private final Map<String, PropertyType> edgePropTypes = new HashMap<String, PropertyType>();
    private final InvalidChangeHandler invalidChangeHandler = new InvalidChangeHandler();
    private int implicitVertexId = 0;
    private long implicitEdgeId = 0L;

    public static <T extends ElementChanges> Map<String, PropertyType> extractPropertyType(List<? extends ChangeTrackingMap.ChangeSetEntry<?, T>> changes) {
        return changes.stream().map(ChangeTrackingMap.ChangeSetEntry::getValue).filter(Objects::nonNull).map(ElementChanges::getPropertyUpdates).map(Map::entrySet).flatMap(Collection::stream).collect(HashMap::new, Changes::getPropertyTypeAndAddEntry, HashMap::putAll);
    }

    private static PropertyType getPropertyTypeAndAddEntry(HashMap<String, PropertyType> map, Map.Entry<String, Object> entry) {
        PropertyType propertyType = Changes.getPropertyType(entry.getValue());
        return map.put(entry.getKey(), propertyType);
    }

    private static PropertyType getPropertyType(Object value) {
        if (value == null) {
            LOG.info("value is NULL. Assuming property type string");
            return PropertyType.STRING;
        }
        return PropertyType.getTypeFor(value.getClass());
    }

    public static IdType extractVertexIdType(List<? extends ChangeTrackingMap.ChangeSetEntry<?, VertexChanges>> vertexChanges, List<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>> edgeChanges) {
        return vertexChanges.stream().map(ChangeTrackingMap.ChangeSetEntry::getKey).findAny().map(Object::getClass).map(IdType::getTypeFor).orElseGet(() -> Changes.getIdType(edgeChanges));
    }

    public static IdType extractEdgeIdType(List<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>> edgeChanges) {
        return edgeChanges.stream().map(ChangeTrackingMap.ChangeSetEntry::getKey).findAny().map(Object::getClass).map(IdType::getTypeFor).map(t -> {
            if (t == IdType.INTEGER) {
                return IdType.LONG;
            }
            return t;
        }).orElse(null);
    }

    private static IdType getIdType(List<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>> edgeChanges) {
        return edgeChanges.stream().map(ChangeTrackingMap.ChangeSetEntry::getValue).filter(Objects::nonNull).filter(ec -> ec.srcId != null || ec.dstId != null).findAny().map(ec -> ec.srcId != null ? ec.srcId : ec.dstId).map(Object::getClass).map(IdType::getTypeFor).orElse(null);
    }

    public static void fixVertexChanges(List<? extends ChangeTrackingMap.ChangeSetEntry<?, VertexChanges>> changes, Map<String, PropertyType> expectedPropTypes, IdType expectedVertexIdType) throws IOException {
        ConsumerWithException additionalFixer = changeEntry -> {
            VertexChanges change = (VertexChanges)changeEntry.getValue();
            if (change == null) {
                return;
            }
            if (change.elementId != null && change.elementId.getClass() != expectedVertexIdType.getTypeClass()) {
                change.elementId = JsonUtil.reparseObject((Object)change.elementId, (Class)expectedVertexIdType.getTypeClass());
            }
        };
        Changes.fixChanges(changes, expectedPropTypes, expectedVertexIdType, additionalFixer);
    }

    public static void fixEdgeChanges(List<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>> changes, Map<String, PropertyType> expectedPropTypes, IdType expectedVertexIdType) throws IOException {
        ConsumerWithException additionalFixer = changeEntry -> {
            EdgeChanges change = (EdgeChanges)changeEntry.getValue();
            if (change == null) {
                return;
            }
            if (change.srcId != null && change.srcId.getClass() != expectedVertexIdType.getTypeClass()) {
                change.srcId = JsonUtil.reparseObject((Object)change.srcId, (Class)expectedVertexIdType.getTypeClass());
            }
            if (change.dstId != null && change.dstId.getClass() != expectedVertexIdType.getTypeClass()) {
                change.dstId = JsonUtil.reparseObject((Object)change.dstId, (Class)expectedVertexIdType.getTypeClass());
            }
        };
        IdType expectedIdType = Changes.extractEdgeIdType(changes);
        Changes.fixChanges(changes, expectedPropTypes, expectedIdType, additionalFixer);
    }

    private static <T extends ElementChanges> void fixChanges(List<? extends ChangeTrackingMap.ChangeSetEntry<?, T>> changes, Map<String, PropertyType> expectedPropertyTypes, IdType expectedIdType, ConsumerWithException<ChangeTrackingMap.ChangeSetEntry<?, T>, IOException> additionalFixes) throws IOException {
        for (ChangeTrackingMap.ChangeSetEntry<?, T> change : changes) {
            ElementChanges elementChange;
            change.fixKey(expectedIdType.getTypeClass());
            if (additionalFixes != null) {
                additionalFixes.acceptWithException(change);
            }
            if ((elementChange = (ElementChanges)change.getValue()) == null) continue;
            elementChange.fixProperties(expectedPropertyTypes);
        }
    }

    public Changes(IdType idType, ChangesIntent intent) {
        this.idType = idType;
        this.intent = intent;
    }

    private void checkVertexIdType(VID vid) {
        Class<?> actualTypeClass;
        if (this.idType == null) {
            return;
        }
        if (vid == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NODE_KEY_NULL", (Object[])new Object[0]));
        }
        Class expectedTypeClass = this.idType.getTypeClass();
        if (!expectedTypeClass.isAssignableFrom(actualTypeClass = vid.getClass())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NODE_ID_UNEXPECTED_TYPE", (Object[])new Object[]{expectedTypeClass, actualTypeClass}));
        }
    }

    public InvalidChangeHandler getInvalidChangeHandler() {
        return this.invalidChangeHandler;
    }

    public OnAddExistingElement getAddExistingVertexPolicy() {
        return this.invalidChangeHandler.getAddExistingVertexPolicy();
    }

    public void setAddExistingVertexPolicy(OnAddExistingElement addExistingVertexPolicy) {
        this.invalidChangeHandler.setAddExistingVertexPolicy(addExistingVertexPolicy);
    }

    public OnAddExistingElement getAddExistingEdgePolicy() {
        return this.invalidChangeHandler.getAddExistingEdgePolicy();
    }

    public void setAddExistingEdgePolicy(OnAddExistingElement addExistingEdgePolicy) {
        this.invalidChangeHandler.setAddExistingEdgePolicy(addExistingEdgePolicy);
    }

    public OnInvalidChange getInvalidChangePolicy() {
        return this.invalidChangeHandler.getInvalidChangePolicy();
    }

    public void setInvalidChangePolicy(OnInvalidChange invalidChangePolicy) {
        this.invalidChangeHandler.setInvalidChangePolicy(invalidChangePolicy);
    }

    public OnRequiredConversion getConversionPolicy() {
        return this.invalidChangeHandler.getRquiredConversionPolicy();
    }

    public void setRequiredConversionPolicy(OnRequiredConversion requiredConversionPolicy) {
        this.invalidChangeHandler.setRquiredConversionPolicy(requiredConversionPolicy);
    }

    public boolean addVertex(VID id) {
        id = EntityIdConversionHelper.tryCastIntegerToLong(id, (IdType)this.idType);
        this.checkVertexIdType(id);
        if (!this.vertexChangesMap.canAdd(id)) {
            this.invalidChangeHandler.handleAddExistingVertex(this.getVertexChangeType(id));
            return false;
        }
        VertexChanges changes = new VertexChanges(id);
        this.vertexChangesMap.trackAdd(id, (Object)changes);
        return true;
    }

    private VID adjustVertexId(int vertexId) {
        switch (this.idType) {
            case LONG: {
                return (VID)Long.valueOf(vertexId);
            }
            case STRING: {
                return (VID)String.valueOf(vertexId);
            }
            case INTEGER: {
                return (VID)Integer.valueOf(vertexId);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_NODE_KEY_TYPE", (Object[])new Object[]{this.idType}));
    }

    public VID getImplicitVertexId() {
        int vertexId = this.implicitVertexId++;
        return this.adjustVertexId(vertexId);
    }

    public long getImplicitEdgeId() {
        long edgeId = this.implicitEdgeId++;
        return edgeId;
    }

    private void lazyAddVertex(VID vertexId) {
        ChangeType vertexChangeType = this.getVertexChangeType(vertexId);
        if (vertexChangeType == null) {
            this.addVertex(vertexId);
        }
    }

    public boolean updateVertex(VID id) {
        this.checkVertexIdType(id);
        if (!this.vertexChangesMap.canModify(id)) {
            this.invalidChangeHandler.handleVertexCollision(ChangeType.MODIFY, this.getVertexChangeType(id));
            return false;
        }
        this.vertexChangesMap.trackModify(id, (Object)new VertexChanges(id));
        return true;
    }

    public boolean updateEdge(Object id) {
        if (!this.edgeChangesMap.canModify(id)) {
            this.invalidChangeHandler.handleEdgeCollision(ChangeType.MODIFY, this.getEdgeChangeType(id));
            return false;
        }
        this.edgeChangesMap.trackModify(id, (Object)new EdgeChanges(id));
        return true;
    }

    public boolean addEdge(Object id, VID srcId, VID dstId, boolean withLazyVertices) {
        if (!this.canConvertSrcAndDstVertexIdTypeAndLogIfNecessary(srcId, dstId, this.idType)) {
            return false;
        }
        srcId = EntityIdConversionHelper.toVertexIdAndLogIfNecessary((IdType)this.idType, srcId, (InvalidChangeHandler)this.invalidChangeHandler, (InvalidChangeHandler.VertexLocation)InvalidChangeHandler.VertexLocation.EDGE_SOURCE);
        dstId = EntityIdConversionHelper.toVertexIdAndLogIfNecessary((IdType)this.idType, dstId, (InvalidChangeHandler)this.invalidChangeHandler, (InvalidChangeHandler.VertexLocation)InvalidChangeHandler.VertexLocation.EDGE_DESTINATION);
        this.checkVertexIdType(srcId);
        this.checkVertexIdType(dstId);
        if (this.edgeChangesMap.canAdd(id)) {
            if (withLazyVertices && this.intent == ChangesIntent.CREATE) {
                this.lazyAddVertex(srcId);
                this.lazyAddVertex(dstId);
            }
            boolean srcMayExist = this.checkVertexUsedByEdgeMayExist(srcId, InvalidChangeHandler.VertexLocation.EDGE_SOURCE);
            boolean dstMayExist = this.checkVertexUsedByEdgeMayExist(dstId, InvalidChangeHandler.VertexLocation.EDGE_DESTINATION);
            if (!srcMayExist || !dstMayExist) {
                return false;
            }
        } else {
            this.invalidChangeHandler.handleAddExistingEdge(this.getEdgeChangeType(id));
            return false;
        }
        EdgeChanges edgeChanges = new EdgeChanges(id, srcId, dstId);
        this.edgeChangesMap.trackAdd(id, (Object)edgeChanges);
        return true;
    }

    public boolean checkVertexUsedByEdgeMayExist(VID vertexId, InvalidChangeHandler.VertexLocation vertexLocation) {
        ChangeType vertexChangeType = this.getVertexChangeType(vertexId);
        switch (this.intent) {
            case CREATE: {
                if (vertexChangeType != null && vertexChangeType != ChangeType.REMOVE) break;
                this.invalidChangeHandler.handleAddEdgeWhereVertexWasRemoved(ChangeType.ADD, ChangeType.REMOVE, vertexLocation);
                return false;
            }
            case MODIFY: {
                if (vertexChangeType != ChangeType.REMOVE) break;
                this.invalidChangeHandler.handleAddEdgeWhereVertexWasRemoved(ChangeType.ADD, ChangeType.REMOVE, vertexLocation);
                return false;
            }
            default: {
                throw new IllegalEnumConstantException((Enum)this.intent);
            }
        }
        return true;
    }

    public boolean setVertexProperty(VID id, String key, Object value) {
        if (!this.checkPropTypeConsistentAndHandleIfNecessary(this.vertexPropTypes, key, value = Changes.convertGroovyInput(value), EntityType.VERTEX)) {
            return false;
        }
        if (!this.vertexChangesMap.canModify(id)) {
            this.invalidChangeHandler.handleVertexCollision(ChangeType.MODIFY, this.getVertexChangeType(id));
            return false;
        }
        VertexChanges vertexChanges = (VertexChanges)this.vertexChangesMap.trackModify(id, (Object)new VertexChanges(id));
        vertexChanges.setPropertyValue(key, value);
        return true;
    }

    private static Object convertGroovyInput(Object value) {
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return bigDecimal.doubleValue();
        }
        return value;
    }

    private boolean checkPropTypeConsistentAndHandleIfNecessary(Map<String, PropertyType> propTypes, String key, Object value, EntityType entityType) {
        PropertyType propertyType = Changes.getPropertyType(value);
        if (propTypes.containsKey(key)) {
            PropertyType expectedPropertyType = propTypes.get(key);
            if (expectedPropertyType != propertyType) {
                this.invalidChangeHandler.handlePropTypeMismatch(key, propertyType, entityType, expectedPropertyType);
                return false;
            }
        } else {
            propTypes.put(key, propertyType);
        }
        return true;
    }

    public boolean setEdgeProperty(Object id, String key, Object value) {
        if (!this.checkPropTypeConsistentAndHandleIfNecessary(this.edgePropTypes, key, value = Changes.convertGroovyInput(value), EntityType.EDGE)) {
            return false;
        }
        if (!this.edgeChangesMap.canModify(id)) {
            this.invalidChangeHandler.handleEdgeCollision(ChangeType.MODIFY, this.getEdgeChangeType(id));
            return false;
        }
        EdgeChanges edgeChanges = (EdgeChanges)this.edgeChangesMap.trackModify(id);
        edgeChanges.setPropertyValue(key, value);
        return true;
    }

    public boolean addVertexLabel(VID id, String label) {
        if (!this.vertexChangesMap.canModify(id)) {
            this.invalidChangeHandler.handleVertexCollision(ChangeType.MODIFY, this.getVertexChangeType(id));
            return false;
        }
        VertexChanges vertexChanges = (VertexChanges)this.vertexChangesMap.trackModify(id, (Object)new VertexChanges(id));
        vertexChanges.addLabel(label);
        return true;
    }

    public boolean removeVertexLabel(VID id, String label) {
        if (!this.vertexChangesMap.canModify(id)) {
            this.invalidChangeHandler.handleVertexCollision(ChangeType.MODIFY, this.getVertexChangeType(id));
            return false;
        }
        VertexChanges vertexChanges = (VertexChanges)this.vertexChangesMap.trackModify(id, (Object)new VertexChanges(id));
        vertexChanges.removeLabel(label);
        return true;
    }

    public boolean setEdgeLabel(Object id, String label) {
        if (!this.edgeChangesMap.canModify(id)) {
            this.invalidChangeHandler.handleEdgeCollision(ChangeType.MODIFY, this.getEdgeChangeType(id));
            return false;
        }
        EdgeChanges edgeChanges = (EdgeChanges)this.edgeChangesMap.trackModify(id);
        edgeChanges.setLabel(label);
        return true;
    }

    public ChangeType getVertexChangeType(VID id) {
        return this.vertexChangesMap.getChangeType(id);
    }

    public ChangeType getEdgeChangeType(Object id) {
        return this.edgeChangesMap.getChangeType(id);
    }

    public List<ChangeTrackingMap.ChangeSetEntry<VID, VertexChanges>> getVertexChanges() {
        return new ArrayList<ChangeTrackingMap.ChangeSetEntry<VID, VertexChanges>>(this.vertexChangesMap.getChanges());
    }

    public List<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>> getEdgeChanges() {
        return new ArrayList<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>>(this.edgeChangesMap.getChanges());
    }

    public int getNumVertexChanges() {
        return this.vertexChangesMap.size();
    }

    public int getNumEdgeChanges() {
        return this.edgeChangesMap.size();
    }

    public String toString() {
        return "added vertices: " + this.vertexChangesMap.getNumAddedValues() + ", modified vertices: " + this.vertexChangesMap.getNumModifiedValues() + ", removed vertices: " + this.vertexChangesMap.getNumRemovedValues() + ", added edges: " + this.edgeChangesMap.getNumAddedValues() + ", modified edges: " + this.edgeChangesMap.getNumModifiedValues() + ", removed edges: " + this.edgeChangesMap.getNumRemovedValues();
    }

    public void resetVertex(VID vertexId) {
        this.checkVertexIdType(vertexId);
        ChangeTrackingMap.ChangeSetEntry resetValue = this.vertexChangesMap.reset(vertexId);
        if (resetValue.getChangeType() == ChangeType.ADD) {
            ArrayList<Object> edgesToRemove = new ArrayList<Object>();
            for (ChangeTrackingMap.ChangeSetEntry changeSetEntry : this.edgeChangesMap.getChanges()) {
                EdgeChanges edgeChange = (EdgeChanges)changeSetEntry.getValue();
                if (!edgeChange.getSrcId().equals(vertexId) && !edgeChange.getDstId().equals(vertexId)) continue;
                edgesToRemove.add(edgeChange.getId());
            }
            for (Object e : edgesToRemove) {
                this.resetEdge(e);
            }
        }
    }

    public void resetEdge(Object edgeId) {
        this.edgeChangesMap.reset(edgeId);
    }

    public boolean removeVertex(VID vertexId) {
        if (!this.vertexChangesMap.canRemove(vertexId)) {
            this.invalidChangeHandler.handleVertexCollision(ChangeType.REMOVE, this.getVertexChangeType(vertexId));
            return false;
        }
        MutableLong numEdgesWhereSrc = new MutableLong(0L);
        MutableLong numEdgesWhereDst = new MutableLong(0L);
        this.getNumEdgesWhereUsed(vertexId, numEdgesWhereSrc, numEdgesWhereDst);
        if (numEdgesWhereSrc.get() > 0L || numEdgesWhereDst.get() > 0L) {
            this.invalidChangeHandler.handleRemoveVertexThatIsUsedByEdge(numEdgesWhereSrc.get(), numEdgesWhereDst.get());
            return false;
        }
        this.vertexChangesMap.trackRemove(vertexId);
        return true;
    }

    private void getNumEdgesWhereUsed(VID vertexId, MutableLong numEdgesWhereSrc, MutableLong numEdgesWhereDst) {
        for (ChangeTrackingMap.ChangeSetEntry edgeChanges : this.edgeChangesMap.getChanges()) {
            if (edgeChanges.getChangeType() == ChangeType.REMOVE || !((EdgeChanges)edgeChanges.getValue()).isComplete()) continue;
            EdgeChanges edgeChange = (EdgeChanges)edgeChanges.getValue();
            if (edgeChange.getSrcId().equals(vertexId)) {
                numEdgesWhereSrc.getAndIncrement();
                continue;
            }
            if (!edgeChange.getDstId().equals(vertexId)) continue;
            numEdgesWhereDst.getAndIncrement();
        }
    }

    public boolean removeEdge(Object edgeId) {
        if (!this.edgeChangesMap.canRemove(edgeId)) {
            this.invalidChangeHandler.handleEdgeCollision(ChangeType.REMOVE, this.getEdgeChangeType(edgeId));
            return false;
        }
        this.edgeChangesMap.trackRemove(edgeId);
        return true;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public Map<String, PropertyType> getVertexPropTypes() {
        return this.vertexPropTypes;
    }

    public Map<String, PropertyType> getEdgePropTypes() {
        return this.edgePropTypes;
    }

    public boolean canConvertSrcAndDstVertexIdTypeAndLogIfNecessary(VID srcVertex, VID dstVertex, IdType idType) {
        boolean canConvertSrcAndDstVertexId = true;
        if (!EntityIdConversionHelper.canConvertVertexId((IdType)idType, srcVertex)) {
            this.invalidChangeHandler.handleVertexIdMismatch(idType, srcVertex, ChangeType.ADD, InvalidChangeHandler.VertexLocation.EDGE_SOURCE);
            canConvertSrcAndDstVertexId = false;
        }
        if (!EntityIdConversionHelper.canConvertVertexId((IdType)idType, dstVertex)) {
            this.invalidChangeHandler.handleVertexIdMismatch(idType, dstVertex, ChangeType.ADD, InvalidChangeHandler.VertexLocation.EDGE_DESTINATION);
            canConvertSrcAndDstVertexId = false;
        }
        return canConvertSrcAndDstVertexId;
    }

    public static enum ChangesIntent {
        CREATE,
        MODIFY;

    }
}

