/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.util.ServiceLoader;
import java.util.Spliterator;
import java.util.stream.StreamSupport;
import oracle.pgx.api.internal.ApiProvider;
import oracle.pgx.common.util.ErrorMessages;

public final class ApiProviderClassFactory {
    public static Class<ApiProvider> provideClass(String mode, String className) {
        return new ApiProviderClassFactory().provide(mode, className);
    }

    public Class<ApiProvider> provide(String mode, String className) {
        return StreamSupport.stream(this.loadApiProvider(), false).map(Object::getClass).filter(clazz -> clazz.getName().equals(className)).findAny().orElseThrow(() -> new IllegalStateException(ErrorMessages.getMessage((String)"API_PROVIDER_NOT_FOUND", (Object[])new Object[]{mode, mode})));
    }

    private Spliterator<ApiProvider> loadApiProvider() {
        ServiceLoader<ApiProvider> apiProviders = ServiceLoader.load(ApiProvider.class);
        return apiProviders.spliterator();
    }
}

