/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.util.concurrent.CompletionException;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.Argument;
import oracle.pgx.api.internal.CoreAnalysisApi;
import oracle.pgx.api.internal.characteristic.WorkloadCharacteristic;
import oracle.pgx.api.internal.characteristic.WorkloadCharacteristicSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBuiltinAlgorithms {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractBuiltinAlgorithms.class);
    protected final CoreAnalysisApi coreAnalysisApi;

    public AbstractBuiltinAlgorithms(CoreAnalysisApi coreAnalysisApi) {
        this.coreAnalysisApi = coreAnalysisApi;
    }

    protected synchronized <T> PgxFuture<T> runAnalysis(SessionContext sessionContext, String id, Argument[] args, Class<T> expectedReturnType, WorkloadCharacteristic ... workloadCharacteristics) {
        WorkloadCharacteristicSet workloadCharacteristicSet = WorkloadCharacteristicSet.of(workloadCharacteristics);
        LOG.debug("computing " + id);
        PgxFuture promise = new PgxFuture();
        ((PgxFuture)this.coreAnalysisApi.runAnalysis(sessionContext, id, args, expectedReturnType, workloadCharacteristicSet).cancelOn(promise).thenAccept(r -> {
            LOG.info("{} execution time = {}ms", (Object)id, (Object)r.getExecutionTimeMs());
            assert (!r.isCanceled());
            if (r.getException() != null) {
                promise.completeExceptionally(r.getException());
            } else {
                promise.complete(r.getReturnValue());
            }
        })).exceptionally(t -> {
            if (t.getClass() == CompletionException.class) {
                t = t.getCause();
            }
            promise.completeExceptionally((Throwable)t);
            return null;
        });
        return promise;
    }
}

