/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema.internal.dispatchers.graph;

import java.util.function.Function;
import oracle.pgx.api.frames.schema.datatypes.graph.EdgeType;
import oracle.pgx.api.frames.schema.datatypes.graph.GraphEntityType;
import oracle.pgx.api.frames.schema.datatypes.graph.VertexType;
import oracle.pgx.api.frames.schema.internal.dispatchers.DataTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.graph.EdgeTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.graph.VertexTypeDispatcher;

@FunctionalInterface
public interface GraphEntityTypeDispatcher<R>
extends Function<GraphEntityType, R> {
    public static <R> GraphEntityTypeDispatcher<R> dispatcher(final VertexTypeDispatcher<R> vertexTypeDispatcher, final EdgeTypeDispatcher<R> edgeTypeDispatcher) {
        return new DefaultGraphEntityTypeDispatcher<R>(){

            @Override
            public R applyVertexType(VertexType type) {
                return DataTypeDispatcher.applyType(vertexTypeDispatcher, type);
            }

            @Override
            public R applyEdgeType(EdgeType type) {
                return DataTypeDispatcher.applyType(edgeTypeDispatcher, type);
            }
        };
    }

    public static <R> R dispatch(VertexTypeDispatcher<R> vertexTypeDispatcher, EdgeTypeDispatcher<R> edgeTypeDispatcher, GraphEntityType dataType) {
        return GraphEntityTypeDispatcher.dispatcher(vertexTypeDispatcher, edgeTypeDispatcher).apply(dataType);
    }

    public static interface DefaultGraphEntityTypeDispatcher<R>
    extends GraphEntityTypeDispatcher<R> {
        @Override
        default public R apply(GraphEntityType dataType) {
            if (dataType instanceof VertexType) {
                return (R)DataTypeDispatcher.applyType(this::applyVertexType, (VertexType)dataType);
            }
            if (dataType instanceof EdgeType) {
                return (R)DataTypeDispatcher.applyType(this::applyEdgeType, (EdgeType)dataType);
            }
            return (R)DataTypeDispatcher.throwNoDispatcherForType(dataType);
        }

        default public R applyVertexType(VertexType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyEdgeType(EdgeType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }
    }
}

