/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxCsvFrameStorer;
import oracle.pgx.api.frames.PgxDbFrameStorer;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.PgxFrameStorer;
import oracle.pgx.api.frames.PgxPgbFrameStorer;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameColumnMetaData;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.common.NotImplementedException;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.GraphPropertyConfigBuilder;

public class PgxGenericFrameStorer
extends PgxFrameStorer<PgxGenericFrameStorer> {
    private String frameName;
    private final Map<String, GraphPropertyConfig> columns = new LinkedHashMap<String, GraphPropertyConfig>();

    public PgxGenericFrameStorer(PgxSession session, Core core, PgxFrame frame, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        super(session, core, frame, keystorePathSupplier, keystorePasswordSupplier);
        this.fromMetaData(this.frame.getMetaData());
    }

    private void fromMetaData(FrameMetaData config) {
        this.name(config.getFrameUid().toString());
        for (FrameColumnMetaData column : config.getColumnMetaDataMap().values()) {
            this.withVectorColumn(column.getColumnId(), column.getType(), column.getDimension());
        }
    }

    @Override
    protected PgxGenericFrameStorer getThis() {
        return this;
    }

    @Override
    public PgxGenericFrameStorer name(String frameName) {
        this.frameName = frameName;
        return this;
    }

    public PgxFrameStorer format(String format) {
        String lowerCase = format.toLowerCase();
        if (lowerCase.equals("csv")) {
            return this.csv();
        }
        if (lowerCase.equals("pgb")) {
            return this.pgb();
        }
        if (lowerCase.equals("db")) {
            return this.db();
        }
        throw new IllegalStateException(ErrorMessages.getMessage((String)"UNKNOWN_FORMAT", (Object[])new Object[]{format}));
    }

    @Override
    protected PgxGenericFrameStorer withVectorColumn(String columnName, PropertyType type, int dimension, Object defaultValue) {
        GraphPropertyConfig propConfig = new GraphPropertyConfigBuilder().setName(columnName).setType(type).setDimension(dimension).setDefault(defaultValue).build();
        this.columns.put(columnName, propConfig);
        return this;
    }

    public PgxDbFrameStorer db() {
        PgxDbFrameStorer reader = new PgxDbFrameStorer(this.session, this.core, this.frame, this.keystorePathSupplier, this.keystorePasswordSupplier);
        this.configureStorer(reader);
        return reader;
    }

    public PgxPgbFrameStorer pgb() {
        PgxPgbFrameStorer reader = new PgxPgbFrameStorer(this.session, this.core, this.frame);
        this.configureStorer(reader);
        return reader;
    }

    public PgxFuture<Void> pgbAsync(String uri) {
        return this.pgb().storeAsync(uri);
    }

    public void pgb(String uri) throws InterruptedException, ExecutionException {
        this.pgbAsync(uri).get();
    }

    public PgxCsvFrameStorer csv() {
        PgxCsvFrameStorer reader = new PgxCsvFrameStorer(this.session, this.core, this.frame);
        this.configureStorer(reader);
        return reader;
    }

    public PgxFuture<Void> csvAsync(String uri) {
        return this.csv().storeAsync(uri);
    }

    public void csv(String uri) throws InterruptedException, ExecutionException {
        this.csvAsync(uri).get();
    }

    @Override
    public PgxFuture<Void> storeAsync(String ... uris) {
        throw new NotImplementedException(ErrorMessages.getMessage((String)"FRAME_FORMAT_AUTODETECTION_NOT_SUPPORTED", (Object[])new Object[0]));
    }

    private void configureStorer(PgxFrameStorer storer) {
        storer.name(this.frameName);
        storer.overwrite(this.overwrite);
        for (GraphPropertyConfig column : this.columns.values()) {
            storer.withVectorColumn(column.getName(), column.getType(), column.getDimension(), column.getDefault());
        }
    }
}

