/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.common.util.AuthCertUtils;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.PartitionedGraphConfig;

class SynchronizerConnectionHandler {
    private PgxGraph graph;

    public SynchronizerConnectionHandler(PgxGraph graph) {
        this.graph = graph;
    }

    Connection getConnection(PartitionedGraphConfig config) {
        if (SynchronizerConnectionHandler.graphConfigContainsConnectionProperties(config)) {
            if (config.getKeystoreAlias() != null) {
                return this.getConnectionUsingKeystore(config);
            }
            return this.getConnectionUsingConnectionInfo(config);
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NO_DB_CONNECTION_INFO", (Object[])new Object[0]));
    }

    static boolean graphConfigContainsConnectionProperties(PartitionedGraphConfig config) {
        return config != null && config.getUsername() != null && config.getJdbcUrl() != null;
    }

    Connection getConnectionUsingConnectionInfo(PartitionedGraphConfig graphConfig) {
        String jdbcUrl = graphConfig.getJdbcUrl();
        String username = graphConfig.getUsername();
        String password = SynchronizerConnectionHandler.retrievePassword(graphConfig);
        try {
            return SynchronizerConnectionHandler.createConnection(jdbcUrl, username, password);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ERROR_TO_ESTABLISH_CONNECTION", (Object[])new Object[]{jdbcUrl, username}), e);
        }
    }

    private static String retrievePassword(PartitionedGraphConfig graphConfig) {
        Object password = graphConfig.getValues().get(PartitionedGraphConfig.Field.PASSWORD);
        return password == null ? null : String.valueOf(password);
    }

    Connection getConnectionUsingKeystore(PartitionedGraphConfig config) {
        return this.getConnectionUsingKeystore(config.getKeystoreAlias(), config.getJdbcUrl(), config.getUsername());
    }

    private Connection getConnectionUsingKeystore(String ksAlias, String jdbcUrl, String username) {
        PgxSession session = this.graph.getSession();
        try {
            return SynchronizerConnectionHandler.createConnection(jdbcUrl, username, AuthCertUtils.getPasswordFromKeystore((String)session.getKeystorePath(), (char[])session.getKeystorePassword(), (String)ksAlias));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"FILE_NOT_FOUND", (Object[])new Object[]{this.graph.getSession().getKeystorePath()}), e);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ERROR_TO_ESTABLISH_CONNECTION", (Object[])new Object[]{jdbcUrl, username}), e);
        }
    }

    static Connection createConnection(String jdbcUrl, String username, String password) throws SQLException {
        return DriverManager.getConnection(jdbcUrl, username, password);
    }
}

