/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Iterator;
import java.util.ListIterator;
import oracle.pgx.api.Destroyable;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.internal.PathProxy;
import oracle.pgx.common.util.ErrorMessages;

public class PgxPath<ID>
extends Destroyable {
    private final PgxGraph graph;
    private final PathProxy proxy;
    private final PathIterable<PgxVertex<ID>> verticesIterable = new PathIterable<PgxVertex<ID>>(){

        @Override
        public PathIterator<PgxVertex<ID>> iterator() {
            return new PathIterator<PgxVertex<ID>>(){

                @Override
                protected PgxVertex<ID> getEntity(Object id) {
                    return PgxPath.this.getVertex(id);
                }

                @Override
                protected ListIterator<Object> listIterator() {
                    return PgxPath.this.proxy.getNodes().listIterator();
                }
            };
        }
    };
    private final PathIterable<PgxEdge> edgesIterable = new PathIterable<PgxEdge>(){

        @Override
        public PathIterator<PgxEdge> iterator() {
            return new PathIterator<PgxEdge>(){

                @Override
                protected PgxEdge getEntity(Object id) {
                    return PgxPath.this.getEdge(id);
                }

                @Override
                protected ListIterator<Object> listIterator() {
                    return PgxPath.this.proxy.getEdges().listIterator();
                }
            };
        }
    };

    PgxPath(PgxGraph graph, PathProxy proxy) {
        assert (graph != null);
        assert (proxy != null);
        assert (!proxy.exists() || proxy.getNodes().size() - 1 == proxy.getEdges().size());
        assert (proxy.getPathLength() == proxy.getEdges().size());
        this.graph = graph;
        this.proxy = proxy;
    }

    public PgxGraph getGraph() {
        return this.graph;
    }

    public boolean exists() {
        return this.proxy.exists();
    }

    public long getPathLengthWithHop() {
        return this.proxy.getPathLength();
    }

    public double getPathLengthWithCost() {
        return this.proxy.getCost();
    }

    public PgxVertex<ID> getSource() {
        if (!this.exists()) {
            return null;
        }
        assert (this.proxy.getNodes().size() > 0);
        Object id = this.proxy.getNodes().get(0);
        return this.getVertex(id);
    }

    public PgxVertex<ID> getDestination() {
        if (!this.exists()) {
            return null;
        }
        assert (this.proxy.getNodes().size() > 0);
        Object id = this.proxy.getNodes().get(this.proxy.getNodes().size() - 1);
        return this.getVertex(id);
    }

    private PgxVertex<ID> getVertex(Object id) {
        return PgxVertex.deserialize(this.graph, id);
    }

    private PgxEdge getEdge(Object id) {
        return PgxEdge.deserialize(this.graph, id);
    }

    public PathIterable<PgxVertex<ID>> getVertices() {
        return this.verticesIterable;
    }

    public PathIterable<PgxEdge> getEdges() {
        return this.edgesIterable;
    }

    public String toString() {
        return this.toString(PgxPath.entry("graph", this.getGraph().getName()), PgxPath.entry("exists", this.exists()));
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return PgxFuture.completedFuture(null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PgxPath other = (PgxPath)obj;
        if (!this.graph.equals(other.graph)) {
            return false;
        }
        if (this.exists() != other.exists()) {
            return false;
        }
        if (this.getPathLengthWithHop() != other.getPathLengthWithHop()) {
            return false;
        }
        if (this.getPathLengthWithCost() != other.getPathLengthWithCost()) {
            return false;
        }
        if (!this.getSource().equals(other.getSource())) {
            return false;
        }
        if (!this.getDestination().equals(other.getDestination())) {
            return false;
        }
        Iterator eit1 = this.getEdges().iterator();
        Iterator eit2 = other.getEdges().iterator();
        while (((PathIterator)eit1).hasNext()) {
            if (!((PathIterator)eit2).hasNext()) {
                return false;
            }
            if (((PgxEdge)((PathIterator)eit1).next()).equals(((PathIterator)eit2).next())) continue;
            return false;
        }
        Iterator nit1 = this.getVertices().iterator();
        Iterator nit2 = other.getVertices().iterator();
        while (((PathIterator)nit1).hasNext()) {
            if (!((PathIterator)nit2).hasNext()) {
                return false;
            }
            if (((PgxVertex)((PathIterator)nit1).next()).equals(((PathIterator)nit2).next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 42;
    }

    public static abstract class PathIterator<E>
    implements ListIterator<E> {
        private ListIterator<Object> it;

        PathIterator() {
            this.reset();
        }

        protected abstract E getEntity(Object var1);

        protected abstract ListIterator<Object> listIterator();

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            return this.getEntity(this.it.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public E previous() {
            return this.getEntity(this.it.previous());
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        public void reset() {
            this.it = this.listIterator();
        }

        @Override
        public void remove() {
            throw PathIterator.readOnlyException();
        }

        @Override
        public void set(E e) {
            throw PathIterator.readOnlyException();
        }

        @Override
        public void add(E e) {
            throw PathIterator.readOnlyException();
        }

        private static RuntimeException readOnlyException() {
            return new UnsupportedOperationException(ErrorMessages.getMessage((String)"PATHS_ARE_READ_ONLY", (Object[])new Object[0]));
        }
    }

    public static interface PathIterable<E>
    extends Iterable<E> {
        @Override
        public PathIterator<E> iterator();
    }
}

