/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import oracle.pgx.api.GraphEntityCollection;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.internal.CollectionProxy;
import oracle.pgx.common.IdentifiableEdgeCollection;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;

public abstract class EdgeCollection
extends GraphEntityCollection<PgxEdge, Long>
implements IdentifiableEdgeCollection {
    private final Function<Long, PgxEdge> boxer = id -> new PgxEdge(this.getGraph(), (Long)id);

    EdgeCollection(PgxGraph graph, PgxId collectionId, String collectionName, CollectionType type) {
        super(graph, collectionId, collectionName, type, EntityType.EDGE);
    }

    @Override
    public IdType getIdType() {
        return IdType.LONG;
    }

    public void addAllById(Long ... ids) throws ExecutionException, InterruptedException {
        this.addAllElements(this.box(this.boxer, ids));
    }

    public void removeAllById(Long ... ids) throws ExecutionException, InterruptedException {
        this.removeAllElements(this.box(this.boxer, ids));
    }

    protected GraphEntityCollection.GraphEntityProxyIterator<PgxEdge, Long> newProxyIterator(CollectionProxy proxy) {
        return new EdgeProxyIterator(this.getGraph(), proxy);
    }

    private static class EdgeProxyIterator
    extends GraphEntityCollection.GraphEntityProxyIterator<PgxEdge, Long> {
        EdgeProxyIterator(PgxGraph graph, CollectionProxy proxy) {
            super(graph, proxy);
        }

        @Override
        protected PgxEdge newEntityObject(Object object) {
            return PgxEdge.deserialize(this.graph, object);
        }
    }
}

