/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library.enhancer;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SelectQuery;

public class EnhancerUtil {
    public static String getPropertyNameFromReference(Set<String> propertyNames, String propertyReference) {
        if (propertyNames.contains(propertyReference)) {
            return propertyReference;
        }
        if (propertyReference.toUpperCase().equals(propertyReference)) {
            for (String property : propertyNames) {
                if (!property.equalsIgnoreCase(propertyReference)) continue;
                return property;
            }
        }
        return null;
    }

    public static QueryVariable recursivelyDereference(QueryExpression expression, boolean dereferencePropRef) {
        QueryVariable variable = null;
        if (expression.getExpType() == QueryExpression.ExpressionType.VARREF) {
            variable = ((QueryExpression.VarRef)expression).getVariable();
        } else if (dereferencePropRef && expression.getExpType() == QueryExpression.ExpressionType.PROP_ACCESS) {
            variable = ((QueryExpression.PropertyAccess)expression).getVariable();
        }
        if (variable != null && variable.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR) {
            return EnhancerUtil.recursivelyDereference((QueryVariable)((ExpAsVar)variable));
        }
        return variable;
    }

    public static QueryVariable recursivelyDereference(QueryVariable var) {
        if (var.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR) {
            ExpAsVar expAsVar = (ExpAsVar)var;
            QueryVariable dereferencedVariable = EnhancerUtil.recursivelyDereference(expAsVar.getExp(), false);
            return dereferencedVariable == null ? expAsVar : dereferencedVariable;
        }
        return var;
    }

    @Nonnull
    public static <T extends QueryExpression> Stream<T> getProjectionsFromQueryOfType(@Nonnull GraphQuery query, @Nonnull Class<T> expressionType) {
        return ((SelectQuery)query).getProjection().getElements().stream().map(ExpAsVar::getExp).filter(exp -> expressionType.isAssignableFrom(exp.getClass())).map(expressionType::cast);
    }

    @Nonnull
    public static <T extends QueryExpression> Stream<ExpAsVar> getProjectionsOfType(@Nonnull Class<T> expresionType, @Nonnull List<ExpAsVar> listEdgesVertices) {
        return listEdgesVertices.stream().filter(expAsVar -> expresionType.isAssignableFrom(expAsVar.getExp().getClass()));
    }

    @Nonnull
    public static Stream<ExpAsVar> getVariableProjectionsOfVarType(boolean includeVertices, boolean includeEdges, @Nonnull List<ExpAsVar> listEdgesVertices) {
        return EnhancerUtil.getProjectionsOfType(QueryExpression.VarRef.class, listEdgesVertices).filter(expAsVar -> {
            QueryVariable baseVar = EnhancerUtil.recursivelyDereference((QueryVariable)expAsVar);
            return includeVertices && baseVar instanceof QueryVertex || includeEdges && baseVar instanceof QueryEdge;
        });
    }

    @Nonnull
    public static Set<String> getProjectedVariableNamesFromQuery(@Nonnull GraphQuery query) {
        return EnhancerUtil.getProjectionsFromQueryOfType(query, QueryExpression.VarRef.class).map(QueryExpression.VarRef::getVariable).map(QueryVariable::getName).collect(Collectors.toSet());
    }
}

