/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library.enhancer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import oracle.pgql.lang.ir.DerivedTable;
import oracle.pgql.lang.ir.Direction;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.TableExpression;
import oracle.pgql.lang.ir.TableExpressionType;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.unnest.OneRowPerStep;
import oracle.pgql.lang.ir.unnest.RowsPerMatch;
import oracle.pgql.lang.ir.unnest.RowsPerMatchType;
import oracle.pgx.common.MutableInteger;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.Property;
import oracle.pgx.graphviz.formatter.Pair;
import oracle.pgx.graphviz.library.enhancer.Enhancement;
import oracle.pgx.graphviz.library.enhancer.EnhancerUtil;
import oracle.pgx.graphviz.library.enhancer.QueryChecker;

public class Enhancer {
    @Nonnull
    private final GraphQuery query;
    @Nonnull
    private final GraphInformation graph;
    @Nonnull
    private final List<String> originalHeader;
    private final boolean isDirectedSupported;

    public Enhancer(@Nonnull GraphQuery query, @Nonnull GraphInformation graph, boolean isDirectedSupported) {
        this.query = query;
        this.graph = graph;
        this.isDirectedSupported = isDirectedSupported;
        if (query.getQueryType() == QueryType.SELECT) {
            SelectQuery selectQuery = (SelectQuery)query;
            this.originalHeader = selectQuery.getProjection().getElements().stream().map(QueryVariable::getName).collect(Collectors.toList());
        } else {
            this.originalHeader = new ArrayList<String>();
        }
    }

    public GraphQuery getQuery() {
        return this.query;
    }

    private static boolean isIdOrLabelFunction(QueryExpression exp) {
        if (exp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL) {
            QueryExpression.FunctionCall funCall = (QueryExpression.FunctionCall)exp;
            return funCall.getPackageName() == null && funCall.getArgs().size() == 1 && (funCall.getFunctionName().equalsIgnoreCase("ID") || funCall.getFunctionName().equalsIgnoreCase("LABEL"));
        }
        return false;
    }

    @Nonnull
    private static WithAllBaseEntitiesOfPropAccess addBaseEntitiesOfPropAccess(@Nonnull GraphQuery query, @Nonnull GraphInformation graph, boolean isDirectedSupported) {
        Enhancement enhancement = new Enhancement(query, graph, isDirectedSupported);
        MutableInteger counter = new MutableInteger(1);
        SelectQuery selectQuery = (SelectQuery)query;
        ArrayList<ExpAsVar> propertyAccessesAsVars = new ArrayList<ExpAsVar>();
        for (ExpAsVar expAsVar : selectQuery.getProjection().getElements()) {
            ExpAsVar baseExpAsVar;
            QueryExpression.ExpressionType type;
            QueryVariable variable = EnhancerUtil.recursivelyDereference((QueryVariable)expAsVar);
            if (variable.getVariableType() != QueryVariable.VariableType.EXP_AS_VAR || (type = (baseExpAsVar = (ExpAsVar)variable).getExp().getExpType()) != QueryExpression.ExpressionType.PROP_ACCESS && type != QueryExpression.ExpressionType.ALL_PROPERTIES && !Enhancer.isIdOrLabelFunction(baseExpAsVar.getExp())) continue;
            propertyAccessesAsVars.add(expAsVar);
        }
        propertyAccessesAsVars.stream().forEach(p -> Enhancer.addBaseEntityOfPropAccess(selectQuery, counter, p));
        return new WithAllBaseEntitiesOfPropAccess(enhancement);
    }

    private static QueryVariable addBaseEntityOfPropAccess(SelectQuery query, MutableInteger counter, ExpAsVar propertyAccessAsVar) {
        QueryExpression exp = propertyAccessAsVar.getExp();
        switch (exp.getExpType()) {
            case PROP_ACCESS: {
                QueryExpression.PropertyAccess propertyAccess = (QueryExpression.PropertyAccess)exp;
                QueryVariable var = propertyAccess.getVariable();
                return Enhancer.createExpAsVarForBaseEntity(query, counter, var);
            }
            case ALL_PROPERTIES: {
                QueryExpression.AllProperties allProperties = (QueryExpression.AllProperties)exp;
                QueryVariable var = allProperties.getVarRef().getVariable();
                return Enhancer.createExpAsVarForBaseEntity(query, counter, var);
            }
            case VARREF: {
                QueryExpression.VarRef varRef = (QueryExpression.VarRef)exp;
                ExpAsVar nestedPropertyAccessAsVar = (ExpAsVar)varRef.getVariable();
                for (TableExpression tableExpression : query.getTableExpressions()) {
                    DerivedTable derivedTable;
                    SelectQuery subquery;
                    if (tableExpression.getTableExpressionType() != TableExpressionType.DERIVED_TABLE || !(subquery = (derivedTable = (DerivedTable)tableExpression).getQuery()).getProjection().getElements().contains(nestedPropertyAccessAsVar)) continue;
                    QueryVariable baseEntity = Enhancer.addBaseEntityOfPropAccess(subquery, counter, nestedPropertyAccessAsVar);
                    ExpAsVar expAsVar = new ExpAsVar((QueryExpression)new QueryExpression.VarRef(baseEntity), baseEntity.getName() + "_" + counter.getAndIncrement(), false);
                    query.getProjection().getElements().add(expAsVar);
                    return expAsVar;
                }
                throw new IllegalStateException("Variable " + varRef + " not defined in any of the subqueries");
            }
            case FUNCTION_CALL: {
                QueryExpression.FunctionCall functionCall = (QueryExpression.FunctionCall)exp;
                QueryExpression.VarRef varRef = (QueryExpression.VarRef)functionCall.getArgs().get(0);
                return Enhancer.createExpAsVarForBaseEntity(query, counter, varRef.getVariable());
            }
        }
        throw new IllegalArgumentException(exp.getExpType() + " not expected");
    }

    private static ExpAsVar createExpAsVarForBaseEntity(SelectQuery query, MutableInteger counter, QueryVariable var) {
        for (ExpAsVar expAsVar : query.getProjection().getElements()) {
            QueryExpression.VarRef varRef;
            if (expAsVar.getExp().getExpType() != QueryExpression.ExpressionType.VARREF || !(varRef = (QueryExpression.VarRef)expAsVar.getExp()).getVariable().getName().equals(var.getName())) continue;
            return expAsVar;
        }
        ExpAsVar expAsVar = new ExpAsVar((QueryExpression)new QueryExpression.VarRef(var), var.getName() + "_" + counter.getAndIncrement(), false);
        query.getProjection().getElements().add(expAsVar);
        return expAsVar;
    }

    @Nonnull
    public Pair<Boolean, String> checkIfVisualizable() {
        return QueryChecker.checkIfVisualizable(this.query);
    }

    @Nonnull
    public List<String> getOriginalHeader() {
        return this.originalHeader;
    }

    @Nonnull
    public Enhancement enhance() {
        assert (((Boolean)this.checkIfVisualizable().getFirst()).booleanValue());
        return Enhancer.addBaseEntitiesOfPropAccess(this.query, this.graph, this.isDirectedSupported).expandEdges().addRemainingProperties().addLabelsAndIds().addEdgeDirection().addIsDestinationForUndirectedQuery().get();
    }

    private static class WithLabels {
        @Nonnull
        private final Enhancement enhancement;

        private WithLabels(@Nonnull Enhancement enhancement) {
            this.enhancement = enhancement;
        }

        @Nonnull
        private Enhancement get() {
            return this.enhancement;
        }
    }

    private static class WithEdgeDirection {
        @Nonnull
        private final Enhancement enhancement;

        private WithEdgeDirection(Enhancement enhancement) {
            this.enhancement = enhancement;
        }

        private WithIsDestinationForUndirectedQueries addEdgeDirection() {
            ArrayList<QueryVariable> edgesToAddIsDirectedFunctionFor = new ArrayList<QueryVariable>();
            for (ExpAsVar expAsVar : this.enhancement.getProjection()) {
                if (EnhancerUtil.recursivelyDereference((QueryVariable)expAsVar).getVariableType() != QueryVariable.VariableType.EDGE) continue;
                QueryExpression.VarRef varRef = (QueryExpression.VarRef)expAsVar.getExp();
                edgesToAddIsDirectedFunctionFor.add(varRef.getVariable());
            }
            edgesToAddIsDirectedFunctionFor.stream().forEach(e -> this.enhancement.addDirectionToEdge((QueryVariable)e));
            return new WithIsDestinationForUndirectedQueries(this.enhancement);
        }
    }

    private static class WithIsDestinationForUndirectedQueries {
        @Nonnull
        private final Enhancement enhancement;

        private WithIsDestinationForUndirectedQueries(Enhancement enhancement) {
            this.enhancement = enhancement;
        }

        private WithLabels addIsDestinationForUndirectedQuery() {
            ArrayList<Pair> vertexEdgePairsForAddingIsDestination = new ArrayList<Pair>();
            for (ExpAsVar expAsVar : this.enhancement.getProjection()) {
                QueryEdge baseEdge;
                QueryVariable variable = EnhancerUtil.recursivelyDereference((QueryVariable)expAsVar);
                if (variable.getVariableType() != QueryVariable.VariableType.EDGE || (baseEdge = (QueryEdge)variable).isDirected() && baseEdge.getDirection() != null) continue;
                QueryVariable edge = ((QueryExpression.VarRef)expAsVar.getExp()).getVariable();
                String destinationName = this.enhancement.getDestVertexForEdge(edge.getName());
                for (ExpAsVar expAsVar2 : this.enhancement.getProjection()) {
                    QueryExpression.VarRef varRef;
                    if (expAsVar2.getExp().getExpType() != QueryExpression.ExpressionType.VARREF || !(varRef = (QueryExpression.VarRef)expAsVar2.getExp()).getVariable().getName().equals(destinationName)) continue;
                    vertexEdgePairsForAddingIsDestination.add(new Pair((Object)edge, (Object)varRef.getVariable()));
                }
            }
            for (Pair vertexEdgePair : vertexEdgePairsForAddingIsDestination) {
                this.enhancement.addIsDestinationOf((QueryVariable)vertexEdgePair.getFirst(), (QueryVariable)vertexEdgePair.getSecond());
            }
            return new WithLabels(this.enhancement);
        }
    }

    private static class WithAllProperties {
        @Nonnull
        private final Enhancement enhancement;

        private WithAllProperties(@Nonnull Enhancement enhancement) {
            this.enhancement = enhancement;
        }

        @Nonnull
        private WithEdgeDirection addLabelsAndIds() {
            Consumer<ExpAsVar> visitVariable = expAsVar -> {
                QueryVariable dereferenced;
                QueryVariable var = ((QueryExpression.VarRef)expAsVar.getExp()).getVariable();
                this.enhancement.addIdToQuery(var);
                GraphInformation graph = this.enhancement.getGraph();
                QueryVariable queryVariable = dereferenced = var.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR ? EnhancerUtil.recursivelyDereference((QueryVariable)((ExpAsVar)var)) : var;
                if (dereferenced.getVariableType() == QueryVariable.VariableType.VERTEX && graph.hasVertexLabels()) {
                    this.addLabelsToQuery(var, graph.supportsMultipleVertexLabels());
                } else if (dereferenced.getVariableType() == QueryVariable.VariableType.EDGE && graph.hasEdgeLabels()) {
                    this.addLabelsToQuery(var, graph.supportsMultipleEdgeLabels());
                }
            };
            List<ExpAsVar> projection = this.enhancement.getProjection();
            EnhancerUtil.getVariableProjectionsOfVarType(true, true, projection).collect(Collectors.toList()).forEach(v -> visitVariable.accept((ExpAsVar)v));
            return new WithEdgeDirection(this.enhancement);
        }

        private void addLabelsToQuery(QueryVariable var, boolean supportsMultipleLabels) {
            String functionName = WithAllProperties.getLabelFunctionName(supportsMultipleLabels);
            this.enhancement.addLabelsToQuery(var, functionName);
        }

        private static String getLabelFunctionName(boolean supportsMultipleLabels) {
            if (supportsMultipleLabels) {
                return "labels";
            }
            return "label";
        }
    }

    private static class WithExpandedEdges {
        @Nonnull
        private final Enhancement enhancement;

        private WithExpandedEdges(@Nonnull Enhancement enhancement) {
            this.enhancement = enhancement;
        }

        @Nonnull
        private static Set<String> getAllowedPropertyNames(@Nonnull Collection<Property> props) {
            return props.stream().filter(Property::isSelectable).map(Property::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        private String generateUniqueAliases(int value) {
            return "_ora_var_" + String.valueOf(value);
        }

        @Nonnull
        private WithAllProperties addRemainingProperties() {
            Set<String> allVertexProperties = WithExpandedEdges.getAllowedPropertyNames(this.enhancement.getGraph().getVertexProperties());
            Set<String> allEdgeProperties = WithExpandedEdges.getAllowedPropertyNames(this.enhancement.getGraph().getEdgeProperties());
            MutableInteger value = new MutableInteger(1);
            HashMap<ExpAsVar, QueryVariable> vertexOrEdgeToVariableType = new HashMap<ExpAsVar, QueryVariable>();
            for (ExpAsVar expAsVar2 : this.enhancement.getProjection()) {
                QueryVariable baseVariable = EnhancerUtil.recursivelyDereference((QueryVariable)expAsVar2);
                QueryVariable.VariableType variableType = baseVariable.getVariableType();
                if (variableType != QueryVariable.VariableType.VERTEX && variableType != QueryVariable.VariableType.EDGE) continue;
                vertexOrEdgeToVariableType.put(expAsVar2, baseVariable);
            }
            HashSet projectionsToAdd = new HashSet();
            for (Map.Entry entry : vertexOrEdgeToVariableType.entrySet()) {
                ExpAsVar vertexOrEdgeAsVar = (ExpAsVar)entry.getKey();
                QueryVariable baseVariable = (QueryVariable)entry.getValue();
                QueryVariable.VariableType variableType = baseVariable.getVariableType();
                HashSet<String> referencedProperties = new HashSet<String>();
                for (ExpAsVar potentialPropAccessAsVar : this.enhancement.getProjection()) {
                    QueryExpression.PropertyAccess propertyAccess;
                    QueryVariable baseVariableFromPropertyAccess;
                    ExpAsVar basePropAccessAsVar;
                    QueryVariable potentialBasePropAccessAsVar = EnhancerUtil.recursivelyDereference((QueryVariable)potentialPropAccessAsVar);
                    if (potentialBasePropAccessAsVar.getVariableType() != QueryVariable.VariableType.EXP_AS_VAR || (basePropAccessAsVar = (ExpAsVar)potentialBasePropAccessAsVar).getExp().getExpType() != QueryExpression.ExpressionType.PROP_ACCESS || (baseVariableFromPropertyAccess = EnhancerUtil.recursivelyDereference((QueryExpression)(propertyAccess = (QueryExpression.PropertyAccess)basePropAccessAsVar.getExp()), true)) != baseVariable) continue;
                    String propertyName = propertyAccess.getPropertyName();
                    referencedProperties.add(propertyName);
                }
                QueryExpression.VarRef varRef = (QueryExpression.VarRef)vertexOrEdgeAsVar.getExp();
                Set<String> nonReferencedProperties = this.getNonReferencedProperties(variableType == QueryVariable.VariableType.VERTEX ? allVertexProperties : allEdgeProperties, referencedProperties);
                nonReferencedProperties.stream().map(p -> new QueryExpression.PropertyAccess(varRef.getVariable(), p)).map(pa -> new ExpAsVar((QueryExpression)pa, this.generateUniqueAliases(value.getAndIncrement()), false)).forEach(p -> projectionsToAdd.add(p));
            }
            projectionsToAdd.stream().forEach(expAsVar -> this.enhancement.addPropertyColumn((ExpAsVar)expAsVar, true, false));
            this.enhancement.getExpsAsVar().filter(expAsVar -> {
                QueryVariable variable = EnhancerUtil.recursivelyDereference(expAsVar.getExp(), true);
                return variable == null || variable.getVariableType() != QueryVariable.VariableType.VERTEX && variable.getVariableType() != QueryVariable.VariableType.EDGE;
            }).filter(expAsVar -> expAsVar.getExp().getExpType() != QueryExpression.ExpressionType.ALL_PROPERTIES).collect(Collectors.toList()).forEach(expAsVar -> {
                if (!Enhancer.isIdOrLabelFunction(expAsVar.getExp())) {
                    this.enhancement.addPropertyColumn((ExpAsVar)expAsVar, false, true);
                }
            });
            return new WithAllProperties(this.enhancement);
        }

        private Set<String> getNonReferencedProperties(Set<String> properties, Set<String> propertyReferences) {
            LinkedHashSet<String> result = new LinkedHashSet<String>(properties);
            for (String propertyReference : propertyReferences) {
                String propertyName = EnhancerUtil.getPropertyNameFromReference(properties, propertyReference);
                if (propertyName == null) continue;
                result.remove(propertyName);
            }
            return result;
        }
    }

    private static class WithAllBaseEntitiesOfPropAccess {
        @Nonnull
        final Enhancement enhancement;

        private WithAllBaseEntitiesOfPropAccess(@Nonnull Enhancement enhancement) {
            this.enhancement = enhancement;
        }

        @Nonnull
        private WithExpandedEdges expandEdges() {
            SelectQuery query = (SelectQuery)this.enhancement.getQuery();
            ArrayList<QueryExpression.VarRef> edgeRefsToExpand = new ArrayList<QueryExpression.VarRef>();
            for (ExpAsVar expAsVar : query.getProjection().getElements()) {
                QueryVariable variable;
                QueryExpression exp = expAsVar.getExp();
                if (exp.getExpType() != QueryExpression.ExpressionType.VARREF || (variable = EnhancerUtil.recursivelyDereference((QueryVariable)expAsVar)).getVariableType() != QueryVariable.VariableType.EDGE) continue;
                edgeRefsToExpand.add((QueryExpression.VarRef)exp);
            }
            for (QueryExpression.VarRef edgeRef : edgeRefsToExpand) {
                Pair<QueryVariable, QueryVariable> edgeSourcePlusDestination = this.expandEdge(query, edgeRef);
                this.enhancement.addEdgeMapping(edgeRef.getVariable().getName(), ((QueryVariable)edgeSourcePlusDestination.getFirst()).getName(), ((QueryVariable)edgeSourcePlusDestination.getSecond()).getName());
            }
            return new WithExpandedEdges(this.enhancement);
        }

        private Pair<QueryVariable, QueryVariable> expandEdge(SelectQuery query, QueryExpression.VarRef edgeRef) {
            String edgeName = edgeRef.getVariable().getName();
            for (TableExpression tableExpression : query.getTableExpressions()) {
                Pair<QueryVariable, QueryVariable> sourceAndDestination = this.tryExpandEdge(query, tableExpression, edgeName);
                if (sourceAndDestination == null) continue;
                return sourceAndDestination;
            }
            throw new IllegalStateException("Edge " + edgeName + " is not defined by any of the table expressions");
        }

        private Pair<QueryVariable, QueryVariable> tryExpandEdge(SelectQuery query, TableExpression tableExpression, String edgeName) {
            switch (tableExpression.getTableExpressionType()) {
                case GRAPH_PATTERN: {
                    GraphPattern graphPattern = (GraphPattern)tableExpression;
                    block8: for (VertexPairConnection connection : graphPattern.getConnections()) {
                        switch (connection.getVariableType()) {
                            case EDGE: {
                                QueryEdge edge = (QueryEdge)connection;
                                if (!edge.getName().equals(edgeName)) continue block8;
                                QueryVariable source = this.expandVertex((GraphQuery)query, (QueryVariable)edge.getSrc());
                                QueryVariable destination = this.expandVertex((GraphQuery)query, (QueryVariable)edge.getDst());
                                return new Pair((Object)source, (Object)destination);
                            }
                            case PATH: {
                                OneRowPerStep oneRowPerStep;
                                QueryEdge edge;
                                QueryPath path = (QueryPath)connection;
                                RowsPerMatch rowsPerMatch = path.getRowsPerMatch();
                                if (rowsPerMatch.getRowsPerMatchType() != RowsPerMatchType.ONE_ROW_PER_STEP || !(edge = (oneRowPerStep = (OneRowPerStep)rowsPerMatch).getEdge()).getName().equals(edgeName)) continue block8;
                                boolean edgesAreIncoming = ((VertexPairConnection)path.getConnections().get(0)).getDirection() == Direction.INCOMING;
                                QueryVariable source = this.expandVertex((GraphQuery)query, (QueryVariable)(edgesAreIncoming ? oneRowPerStep.getVertex2() : oneRowPerStep.getVertex1()));
                                QueryVariable destination = this.expandVertex((GraphQuery)query, (QueryVariable)(edgesAreIncoming ? oneRowPerStep.getVertex1() : oneRowPerStep.getVertex2()));
                                return new Pair((Object)source, (Object)destination);
                            }
                            default: {
                                throw new IllegalStateException(connection.getVariableType() + " not expected");
                            }
                        }
                    }
                    break;
                }
                case DERIVED_TABLE: {
                    DerivedTable derivedTable = (DerivedTable)tableExpression;
                    SelectQuery nestedQuery = derivedTable.getQuery();
                    QueryExpression.VarRef varRefToExpand = null;
                    for (ExpAsVar expAsVar : nestedQuery.getProjection().getElements()) {
                        if (!expAsVar.getName().equals(edgeName)) continue;
                        varRefToExpand = (QueryExpression.VarRef)expAsVar.getExp();
                        break;
                    }
                    if (varRefToExpand == null) break;
                    Pair<QueryVariable, QueryVariable> sourceAndDestination = this.expandEdge(nestedQuery, varRefToExpand);
                    QueryVariable source = this.expandVertex((GraphQuery)query, (QueryVariable)sourceAndDestination.getFirst());
                    QueryVariable destination = this.expandVertex((GraphQuery)query, (QueryVariable)sourceAndDestination.getSecond());
                    return new Pair((Object)source, (Object)destination);
                }
                default: {
                    throw new UnsupportedOperationException(query.getTableExpressions() + " not supported");
                }
            }
            return null;
        }

        private QueryVariable expandVertex(@Nonnull GraphQuery query, @Nonnull QueryVariable vertex) {
            vertex.setAnonymous(false);
            if (!EnhancerUtil.getProjectedVariableNamesFromQuery(query).contains(vertex.getName())) {
                ExpAsVar expAsVar = new ExpAsVar((QueryExpression)new QueryExpression.VarRef(vertex), vertex.getName(), true);
                ((SelectQuery)query).getProjection().getElements().add(expAsVar);
                return expAsVar;
            }
            return vertex;
        }
    }
}

