/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.parallel.stratego_parallel;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.spoofax.terms.util.NotImplementedException;

public class ParallelJobExecutor
extends ThreadPoolExecutor {
    private final int asyncMaxPoolSize;
    private final boolean isConstantPoolSize;
    private int asyncPoolSize;

    public ParallelJobExecutor() {
        this(Math.max(8, 2), Math.max(8, 2));
    }

    public ParallelJobExecutor(int activeThreads, int maxThreads) {
        super(activeThreads - 1, maxThreads - 1, 60L, TimeUnit.SECONDS, ParallelJobExecutor.createQueue());
        this.isConstantPoolSize = activeThreads == maxThreads;
        this.asyncPoolSize = activeThreads;
        this.asyncMaxPoolSize = maxThreads;
    }

    private static BlockingQueue<Runnable> createQueue() {
        int capacity = 16;
        return new ArrayBlockingQueue<Runnable>(16, true);
    }

    @Override
    public synchronized int getCorePoolSize() {
        return super.getCorePoolSize();
    }

    @Override
    public synchronized int getMaximumPoolSize() {
        return super.getMaximumPoolSize();
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        throw new NotImplementedException();
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        throw new NotImplementedException();
    }

    public void join() {
        Runnable job;
        BlockingQueue<Runnable> queue = this.getQueue();
        while ((job = (Runnable)queue.poll()) != null) {
            job.run();
        }
    }

    public synchronized void asyncBeginSleep() {
        if (!this.isConstantPoolSize) {
            ++this.asyncPoolSize;
            if (this.asyncPoolSize <= this.asyncMaxPoolSize) {
                super.setCorePoolSize(this.asyncPoolSize);
            }
        }
    }

    public synchronized void asyncEndSleep() {
        if (!this.isConstantPoolSize) {
            --this.asyncPoolSize;
            if (this.asyncPoolSize <= this.asyncMaxPoolSize) {
                super.setCorePoolSize(this.asyncPoolSize);
            }
        }
    }
}

