/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.parallel.collections;

import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.InteropContext;
import org.strategoxt.lang.parallel.collections.IThreadBoundCollection;
import org.strategoxt.lang.parallel.collections.ParallelCollectionLibrary;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelContext;
import org.strategoxt.lang.parallel.stratego_parallel.stratego_parallel;

public class ParallelRead
extends AbstractPrimitive {
    private final ParallelCollectionLibrary library;
    private final AbstractPrimitive primitive;
    private final int tableIndex;

    public ParallelRead(ParallelCollectionLibrary library, AbstractPrimitive primitive, int tableIndex) {
        super(primitive.getName(), primitive.getSArity(), primitive.getTArity());
        this.library = library;
        this.primitive = primitive;
        this.tableIndex = tableIndex;
    }

    public ParallelRead(ParallelCollectionLibrary library, AbstractPrimitive primitive) {
        this(library, primitive, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean call(IContext env, Strategy[] sargs, IStrategoTerm[] targs) throws InterpreterException {
        if (!stratego_parallel.isActive()) {
            return this.primitive.call(env, sargs, targs);
        }
        if (targs[this.tableIndex] instanceof IThreadBoundCollection) {
            return this.primitive.call(env, sargs, targs);
        }
        ParallelContext context = (ParallelContext)((InteropContext)env).getContext();
        if (!context.getJob().isFocusJob()) {
            context.waitForFocus();
        }
        Object object = this.library.getSyncRoot();
        synchronized (object) {
            return this.primitive.call(env, sargs, targs);
        }
    }
}

