/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io.binary;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BitStream {
    private final InputStream stream;
    private int bitsInBuffer;
    private int bitBuffer;

    public BitStream(InputStream inputStream) {
        this.stream = inputStream;
        this.bitsInBuffer = 0;
        this.bitBuffer = 0;
    }

    public int readInt() throws IOException {
        int buf0 = this.readByte();
        if ((buf0 & 0x80) == 0) {
            return buf0;
        }
        int buf1 = this.readByte();
        if ((buf0 & 0x40) == 0) {
            return buf1 + ((buf0 & 0xFFFFFF3F) << 8);
        }
        int buf2 = this.readByte();
        if ((buf0 & 0x20) == 0) {
            return buf2 + (buf1 << 8) + ((buf0 & 0xFFFFFF1F) << 16);
        }
        int buf3 = this.readByte();
        if ((buf0 & 0x10) == 0) {
            return buf3 + (buf2 << 8) + (buf1 << 16) + ((buf0 & 0xFFFFFF0F) << 24);
        }
        int buf4 = this.readByte();
        return buf4 + (buf3 << 8) + (buf2 << 16) + (buf1 << 24);
    }

    protected int readByte() throws IOException {
        int c = this.stream.read();
        if (c == -1) {
            throw new EOFException();
        }
        return c;
    }

    public String readString() throws IOException {
        int l = this.readInt();
        byte[] b = new byte[l];
        int v = 0;
        while (v < b.length) {
            v += this.stream.read(b, v, b.length - v);
        }
        return new String(b);
    }

    public int readBits(int nrBits) throws IOException {
        int mask = 1;
        int val = 0;
        int i = 0;
        while (i < nrBits) {
            if (this.bitsInBuffer == 0) {
                int v = this.readByte();
                if (v == -1) {
                    return -1;
                }
                this.bitBuffer = v;
                this.bitsInBuffer = 8;
            }
            val |= (this.bitBuffer & 0x80) != 0 ? mask : 0;
            mask <<= 1;
            this.bitBuffer <<= 1;
            --this.bitsInBuffer;
            ++i;
        }
        return val;
    }

    public void flushBitsFromReader() {
        this.bitsInBuffer = 0;
    }
}

