/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.layoutsensitive;

import java.util.Optional;
import org.metaborg.sdf2table.grammar.layoutconstraints.ArithmeticLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.BooleanLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.ComparisonLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.ILayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.ILayoutConstraintExpression;
import org.metaborg.sdf2table.grammar.layoutconstraints.NumericLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.TreeRef;
import org.spoofax.jsglr2.layoutsensitive.ILayoutSensitiveParseForest;
import org.spoofax.jsglr2.layoutsensitive.ILayoutSensitiveParseNode;
import org.spoofax.jsglr2.layoutsensitive.LayoutSensitiveParseNode;
import org.spoofax.jsglr2.parser.Position;

public class LayoutConstraintEvaluator {
    public static <ParseForest extends ILayoutSensitiveParseForest> boolean evaluate(ILayoutConstraint layoutConstraint, ParseForest[] parseNodes) {
        if (layoutConstraint instanceof BooleanLayoutConstraint) {
            return LayoutConstraintEvaluator.evaluateBoolean((BooleanLayoutConstraint)((BooleanLayoutConstraint)layoutConstraint), parseNodes);
        }
        if (layoutConstraint instanceof ComparisonLayoutConstraint) {
            return LayoutConstraintEvaluator.evaluateComparison((ComparisonLayoutConstraint)((ComparisonLayoutConstraint)layoutConstraint), parseNodes);
        }
        throw new IllegalStateException("Could not evaluate constraint: " + layoutConstraint);
    }

    private static <ParseForest extends ILayoutSensitiveParseForest> boolean evaluateBoolean(BooleanLayoutConstraint booleanConstraint, ParseForest[] parseNodes) {
        boolean c1Result = LayoutConstraintEvaluator.evaluate((ILayoutConstraint)booleanConstraint.getC1(), parseNodes);
        switch (booleanConstraint.getOp()) {
            case AND: {
                return c1Result && LayoutConstraintEvaluator.evaluate((ILayoutConstraint)booleanConstraint.getC2(), parseNodes);
            }
            case OR: {
                return c1Result || LayoutConstraintEvaluator.evaluate((ILayoutConstraint)booleanConstraint.getC2(), parseNodes);
            }
            case NOT: {
                return !c1Result;
            }
        }
        throw new IllegalStateException("Could not evaluate boolean constraint: " + booleanConstraint);
    }

    private static <ParseForest extends ILayoutSensitiveParseForest> boolean evaluateComparison(ComparisonLayoutConstraint comparisonConstraint, ParseForest[] parseNodes) {
        Optional c1ResultOpt = LayoutConstraintEvaluator.evaluateExpression((ILayoutConstraintExpression)comparisonConstraint.getC1(), parseNodes);
        Optional c2ResultOpt = LayoutConstraintEvaluator.evaluateExpression((ILayoutConstraintExpression)comparisonConstraint.getC2(), parseNodes);
        if (!c1ResultOpt.isPresent() || !c2ResultOpt.isPresent()) {
            return true;
        }
        int c1Result = (Integer)c1ResultOpt.get();
        int c2Result = (Integer)c2ResultOpt.get();
        switch (comparisonConstraint.getOp()) {
            case EQ: {
                return c1Result == c2Result;
            }
            case GE: {
                return c1Result >= c2Result;
            }
            case GT: {
                return c1Result > c2Result;
            }
            case LE: {
                return c1Result <= c2Result;
            }
            case LT: {
                return c1Result < c2Result;
            }
        }
        throw new IllegalStateException("Could not evaluate comparison constraint: " + comparisonConstraint);
    }

    private static <ParseForest extends ILayoutSensitiveParseForest> Optional<Integer> evaluateExpression(ILayoutConstraintExpression layoutConstraint, ParseForest[] parseNodes) {
        if (layoutConstraint instanceof NumericLayoutConstraint) {
            NumericLayoutConstraint numericLayoutConstraint = (NumericLayoutConstraint)layoutConstraint;
            return Optional.of(numericLayoutConstraint.getNum());
        }
        if (layoutConstraint instanceof TreeRef) {
            return LayoutConstraintEvaluator.evaluateTreeRef((TreeRef)((TreeRef)layoutConstraint), parseNodes);
        }
        if (layoutConstraint instanceof ArithmeticLayoutConstraint) {
            return LayoutConstraintEvaluator.evaluateArithmetic((ArithmeticLayoutConstraint)((ArithmeticLayoutConstraint)layoutConstraint), parseNodes);
        }
        throw new IllegalStateException("Could not evaluate constraint expression: " + layoutConstraint);
    }

    private static <ParseForest extends ILayoutSensitiveParseForest> Optional<Integer> evaluateTreeRef(TreeRef treeRefConstraint, ParseForest[] parseNodes) {
        Position pos;
        ParseForest tree = parseNodes[treeRefConstraint.getTree()];
        if (tree instanceof LayoutSensitiveParseNode && ((ILayoutSensitiveParseNode)tree).production().isIgnoreLayoutConstraint()) {
            return Optional.empty();
        }
        if (tree.getStartPosition() == tree.getEndPosition()) {
            return Optional.empty();
        }
        switch (treeRefConstraint.getToken()) {
            case FIRST: {
                pos = tree.getStartPosition();
                break;
            }
            case LAST: {
                pos = tree.getEndPosition();
                break;
            }
            case LEFT: {
                if (tree instanceof ILayoutSensitiveParseNode) {
                    ILayoutSensitiveParseNode layoutSensitiveParseNode = (ILayoutSensitiveParseNode)tree;
                    if (layoutSensitiveParseNode.getLeftPosition() == null) {
                        return Optional.empty();
                    }
                    pos = layoutSensitiveParseNode.getLeftPosition();
                    break;
                }
                return Optional.empty();
            }
            case RIGHT: {
                if (tree instanceof ILayoutSensitiveParseNode) {
                    ILayoutSensitiveParseNode layoutSensitiveParseNode = (ILayoutSensitiveParseNode)tree;
                    if (layoutSensitiveParseNode.getRightPosition() == null) {
                        return Optional.empty();
                    }
                    pos = layoutSensitiveParseNode.getRightPosition();
                    break;
                }
                return Optional.empty();
            }
            default: {
                throw new IllegalStateException("Could not evaluate TreeRef token: " + (Object)((Object)treeRefConstraint.getToken()));
            }
        }
        switch (treeRefConstraint.getElem()) {
            case COL: {
                return Optional.of(pos.column);
            }
            case LINE: {
                return Optional.of(pos.line);
            }
        }
        throw new IllegalStateException("Could not evaluate TreeRef element: " + (Object)((Object)treeRefConstraint.getElem()));
    }

    private static <ParseForest extends ILayoutSensitiveParseForest> Optional<Integer> evaluateArithmetic(ArithmeticLayoutConstraint arithmeticConstraint, ParseForest[] parseNodes) {
        Optional c1ResultOpt = LayoutConstraintEvaluator.evaluateExpression((ILayoutConstraintExpression)arithmeticConstraint.getC1(), parseNodes);
        Optional c2ResultOpt = LayoutConstraintEvaluator.evaluateExpression((ILayoutConstraintExpression)arithmeticConstraint.getC2(), parseNodes);
        if (!c1ResultOpt.isPresent() || !c2ResultOpt.isPresent()) {
            return Optional.empty();
        }
        int c1Result = (Integer)c1ResultOpt.get();
        int c2Result = (Integer)c2ResultOpt.get();
        switch (arithmeticConstraint.getOp()) {
            case ADD: {
                return Optional.of(c1Result + c2Result);
            }
            case DIV: {
                return Optional.of(c1Result / c2Result);
            }
            case MUL: {
                return Optional.of(c1Result * c2Result);
            }
            case SUB: {
                return Optional.of(c1Result - c2Result);
            }
        }
        throw new IllegalStateException("Could not evaluate arithmetic constraint: " + arithmeticConstraint);
    }
}

