/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.incremental;

import java.util.Objects;

public class EditorUpdate {
    public final int deletedStart;
    public final int deletedEnd;
    public final String inserted;

    public EditorUpdate(int deletedStart, int deletedEnd, String inserted) {
        this.deletedStart = deletedStart;
        this.deletedEnd = deletedEnd;
        this.inserted = inserted;
    }

    public Type getType() {
        if (this.deletedStart == this.deletedEnd) {
            return Type.INSERTION;
        }
        if (this.inserted.length() == 0) {
            return Type.DELETION;
        }
        return Type.REPLACEMENT;
    }

    public int deletedLength() {
        return this.deletedEnd - this.deletedStart;
    }

    public int insertedLength() {
        return this.inserted.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditorUpdate that = (EditorUpdate)o;
        return this.deletedStart == that.deletedStart && this.deletedEnd == that.deletedEnd && this.inserted.equals(that.inserted);
    }

    public int hashCode() {
        return Objects.hash(this.deletedStart, this.deletedEnd, this.inserted);
    }

    public String toString() {
        return "EditorUpdate{deletedStart=" + this.deletedStart + ", deletedEnd=" + this.deletedEnd + ", inserted='" + this.inserted + '\'' + '}';
    }

    public static enum Type {
        DELETION,
        INSERTION,
        REPLACEMENT;

    }
}

