/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.treediff;

import java.util.ArrayList;
import org.spoofax.interpreter.library.jsglr.treediff.AbstractTreeMatcher;
import org.spoofax.interpreter.library.jsglr.treediff.HelperFunctions;
import org.spoofax.interpreter.library.jsglr.treediff.LCSOriginTermsCommand;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.attachments.DesugaredOriginAttachment;
import org.spoofax.terms.attachments.OriginAttachment;

public class OriginTreeMatcher
extends AbstractTreeMatcher {
    private boolean useDesugaredOrigins;
    private boolean requireSameSignature;
    private boolean requireSameValue;

    public OriginTreeMatcher(boolean useDesugaredOrigins, boolean requireSameSignature, boolean requireSameValue) {
        super(new LCSOriginTermsCommand(), true);
        this.useDesugaredOrigins = useDesugaredOrigins;
    }

    @Override
    ArrayList<IStrategoTerm> getCandidateMatchTerms(IStrategoTerm root1, IStrategoTerm t2) {
        IStrategoTerm origin;
        IStrategoTerm desugaredOrigin;
        ArrayList<IStrategoTerm> candidates = new ArrayList<IStrategoTerm>();
        if (this.useDesugaredOrigins && (desugaredOrigin = DesugaredOriginAttachment.getDesugaredOrigin(t2)) != null) {
            candidates.add(desugaredOrigin);
        }
        if ((origin = OriginAttachment.getOrigin(t2)) != null) {
            candidates.add(origin);
        }
        return candidates;
    }

    @Override
    double matchingScore(IStrategoTerm t1, IStrategoTerm t2) {
        if (t1 == null || t2 == null) {
            return -1.0;
        }
        if (this.requireSameSignature && !HelperFunctions.haveSameSignature(t1, t2)) {
            return -1.0;
        }
        if (this.requireSameValue && HelperFunctions.isPrimitiveType(t1) && !HelperFunctions.isPrimitiveWithSameValue(t1, t2)) {
            return -1.0;
        }
        if (OriginAttachment.getOrigin(t2) != t1 && DesugaredOriginAttachment.getDesugaredOrigin(t2) != t1) {
            return -1.0;
        }
        double value = 0.0;
        double maxValue = 5.0;
        if (HelperFunctions.haveSameSignature(t1, t2) || HelperFunctions.isPrimitiveWithSameValue(t1, t2)) {
            value += 2.0;
            if (t1.equals(t2)) {
                value += 2.0;
            }
        }
        if (DesugaredOriginAttachment.getDesugaredOrigin(t2) == t1) {
            value += 1.0;
        }
        return 1.0 * value / maxValue;
    }
}

