/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.future;

import org.metaborg.util.functions.CheckedAction1;
import org.metaborg.util.functions.CheckedAction2;
import org.metaborg.util.functions.CheckedFunction1;
import org.metaborg.util.functions.CheckedFunction2;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;

class CompletedFuture<T>
implements ICompletableFuture<T> {
    private final T result;

    public CompletedFuture(T result) {
        this.result = result;
    }

    @Override
    public void complete(T value, Throwable ex) {
    }

    @Override
    public <U> IFuture<U> handle(CheckedFunction2<? super T, Throwable, ? extends U, ? extends Throwable> handler) {
        try {
            return CompletableFuture.completedFuture(handler.apply(this.result, null));
        }
        catch (Throwable ex) {
            return CompletableFuture.completedExceptionally(ex);
        }
    }

    @Override
    public IFuture<T> whenComplete(CheckedAction2<? super T, Throwable, ? extends Throwable> handler) {
        try {
            handler.apply(this.result, null);
            return CompletableFuture.completedFuture(this.result);
        }
        catch (Throwable ex) {
            return CompletableFuture.completedExceptionally(ex);
        }
    }

    @Override
    public <U> IFuture<U> thenApply(CheckedFunction1<? super T, ? extends U, ? extends Throwable> handler) {
        try {
            return CompletableFuture.completedFuture(handler.apply(this.result));
        }
        catch (Throwable ex) {
            return CompletableFuture.completedExceptionally(ex);
        }
    }

    @Override
    public IFuture<Void> thenAccept(CheckedAction1<? super T, ? extends Throwable> handler) {
        try {
            handler.apply(this.result);
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable ex) {
            return CompletableFuture.completedExceptionally(ex);
        }
    }

    @Override
    public <U> IFuture<U> thenCompose(CheckedFunction1<? super T, ? extends IFuture<? extends U>, ? extends Throwable> handler) {
        try {
            return handler.apply(this.result);
        }
        catch (Throwable ex) {
            return CompletableFuture.completedExceptionally(ex);
        }
    }

    @Override
    public <U> IFuture<U> compose(CheckedFunction2<? super T, Throwable, ? extends IFuture<? extends U>, ? extends Throwable> handler) {
        try {
            return handler.apply(this.result, null);
        }
        catch (Throwable ex) {
            return CompletableFuture.completedExceptionally(ex);
        }
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public java.util.concurrent.CompletableFuture<T> asJavaCompletion() {
        java.util.concurrent.CompletableFuture<T> future = new java.util.concurrent.CompletableFuture<T>();
        future.complete(this.result);
        return future;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode());
    }
}

