/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.tracing;

import com.google.inject.Inject;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.source.ISourceLocation;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.spoofax.core.dynamicclassloading.BuilderInput;
import org.metaborg.spoofax.core.stratego.IStrategoCommon;
import org.metaborg.spoofax.core.tracing.ISpoofaxTracingService;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.strategoxt.HybridInterpreter;

public class TracingCommon {
    private static final ILogger logger = LoggerUtils.logger(TracingCommon.class);
    private final ISpoofaxTracingService tracingService;
    private final IStrategoCommon common;

    @Inject
    public TracingCommon(ISpoofaxTracingService tracingService, IStrategoCommon common) {
        this.tracingService = tracingService;
        this.common = common;
    }

    public TermWithRegion outputs(ITermFactory termFactory, HybridInterpreter runtime, FileObject location, FileObject resource, IStrategoTerm result, Iterable<IStrategoTerm> inRegion, String strategy) throws MetaborgException {
        for (IStrategoTerm term : inRegion) {
            BuilderInput inputTerm = this.common.builderInputTerm(term, resource, location);
            IStrategoTerm output = this.common.invoke(runtime, inputTerm, strategy);
            if (output == null) continue;
            ISourceLocation highlightLocation = this.tracingService.location(term);
            if (highlightLocation == null) {
                logger.debug("Cannot get source region for {}", term);
                continue;
            }
            return new TermWithRegion(output, highlightLocation.region());
        }
        return null;
    }

    @Nullable
    public ISourceLocation getTargetLocation(IStrategoTerm term) {
        ISourceLocation targetLocation = this.tracingService.location(term);
        if (targetLocation == null || targetLocation.resource() == null) {
            return null;
        }
        return targetLocation;
    }

    public static class TermWithRegion {
        public final IStrategoTerm term;
        public final ISourceRegion region;

        public TermWithRegion(IStrategoTerm term, ISourceRegion region) {
            this.term = term;
            this.region = region;
        }
    }
}

