/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.io;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public class Benchmark {
    public static final ComposedTask main;
    public static ComposedTask current;

    static {
        current = main = new ComposedTask("to_parse_table");
    }

    public static String tabulation(int tab) {
        String str = "";
        while (tab > 0) {
            str = String.valueOf(str) + "...";
            --tab;
        }
        return str;
    }

    public static String formatTime(long t) {
        String millis = String.valueOf(t % 1000L);
        while (millis.length() < 3) {
            millis = "0" + millis;
        }
        return String.valueOf(String.valueOf(t / 1000L)) + "." + millis + "s";
    }

    public static SingleTask newSingleTask(String name) {
        return current.newSingleTask(name);
    }

    public static ComposedTask newComposedTask(String name) {
        return current.newComposedTask(name);
    }

    public static DistributedTask newDistributedTask(String name) {
        return current.newDistributedTask(name);
    }

    public static void reset() {
        main.reset();
        current = main;
    }

    public static void print(PrintStream out) {
        if (out == System.err) {
            out.println("===== benchmark =====");
            main.print(out, 0);
            out.println("=====================");
        } else {
            main.print(out, 0);
        }
    }

    public static long printStatistics(String step, long totalTime) {
        String millis = String.valueOf(totalTime % 1000L);
        while (millis.length() < 3) {
            millis = "0" + millis;
        }
        System.out.println(String.valueOf(step) + String.valueOf(totalTime / 1000L) + "." + millis + "s");
        return totalTime;
    }

    public static class ComposedTask
    extends Task {
        List<Task> _sub_task = new LinkedList<Task>();
        ComposedTask _parent = null;

        public ComposedTask(String name) {
            super(name);
        }

        public void start() {
            this._parent = current;
            current = this;
        }

        public void stop() {
            current = this._parent;
        }

        public void reset() {
            this._sub_task.clear();
        }

        public Task newTask(Task task) {
            this._sub_task.add(task);
            return task;
        }

        public SingleTask newSingleTask(String name) {
            SingleTask task = new SingleTask(name);
            this._sub_task.add(task);
            return task;
        }

        public ComposedTask newComposedTask(String name) {
            ComposedTask task = new ComposedTask(name);
            this._sub_task.add(task);
            return task;
        }

        public DistributedTask newDistributedTask(String name) {
            DistributedTask task = new DistributedTask(name);
            this._sub_task.add(task);
            return task;
        }

        @Override
        public void print(PrintStream out, int tab) {
            if (out == System.err) {
                out.println(String.valueOf(Benchmark.tabulation(tab)) + this.name() + ": " + Benchmark.formatTime(this.duration()));
                for (Task t : this._sub_task) {
                    t.print(out, tab + 1);
                }
            } else {
                out.print(";" + (double)this.duration() / 1000.0);
                for (Task t : this._sub_task) {
                    t.print(out, 0);
                }
            }
        }

        @Override
        public long startTime() {
            if (this._sub_task.isEmpty()) {
                return 0L;
            }
            return this._sub_task.get(0).startTime();
        }

        @Override
        public long endTime() {
            if (this._sub_task.isEmpty()) {
                return 0L;
            }
            return this._sub_task.get(this._sub_task.size() - 1).endTime();
        }
    }

    public static class DistributedTask
    extends Task {
        private long _start_time = -1L;
        private long _resume_time = -1L;
        private long _end_time = -1L;
        private long _duration = 0L;
        private int _started = 0;

        public DistributedTask(String name) {
            super(name);
        }

        public void start() {
            ++this._started;
            if (this._started > 1) {
                return;
            }
            this._resume_time = System.currentTimeMillis();
            if (this._start_time == -1L) {
                this._start_time = this._resume_time;
            }
        }

        public void stop() {
            --this._started;
            if (this._started > 0) {
                return;
            }
            this._end_time = System.currentTimeMillis();
            this._duration += this._end_time - this._resume_time;
        }

        @Override
        public long duration() {
            return this._duration;
        }

        @Override
        public void print(PrintStream out, int tab) {
            if (out == System.err) {
                out.println(String.valueOf(Benchmark.tabulation(tab)) + " [#] " + this.name() + ": " + Benchmark.formatTime(this.duration()));
            } else {
                out.print(";" + (double)this.duration() / 1000.0);
            }
        }

        @Override
        public long startTime() {
            return this._start_time;
        }

        @Override
        public long endTime() {
            return this._end_time;
        }
    }

    public static class SingleTask
    extends Task {
        private long _start_time;
        private long _end_time;

        public SingleTask(String name) {
            super(name);
        }

        public void start() {
            this._start_time = System.currentTimeMillis();
        }

        public void stop() {
            this._end_time = System.currentTimeMillis();
        }

        @Override
        public void print(PrintStream out, int tab) {
            if (out == System.err) {
                out.println(String.valueOf(Benchmark.tabulation(tab)) + this.name() + ": " + Benchmark.formatTime(this.duration()));
            } else {
                out.print(";" + (double)this.duration() / 1000.0);
            }
        }

        @Override
        public long startTime() {
            return this._start_time;
        }

        @Override
        public long endTime() {
            return this._end_time;
        }
    }

    public static abstract class Task {
        String _name;

        public Task(String name) {
            this._name = name;
        }

        public String name() {
            return this._name;
        }

        public abstract long startTime();

        public abstract long endTime();

        public long duration() {
            return this.endTime() - this.startTime();
        }

        public abstract void print(PrintStream var1, int var2);
    }
}

