/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.states;

import java.util.Set;
import org.metaborg.parsetable.actions.IGoto;
import org.metaborg.parsetable.query.ActionsForCharacterDisjointSorted;
import org.metaborg.parsetable.query.ActionsForCharacterRepresentation;
import org.metaborg.parsetable.query.ActionsForCharacterSeparated;
import org.metaborg.parsetable.query.ActionsPerCharacterClass;
import org.metaborg.parsetable.query.IActionsForCharacter;
import org.metaborg.parsetable.query.IProductionToGoto;
import org.metaborg.parsetable.query.ProductionToGotoForLoop;
import org.metaborg.parsetable.query.ProductionToGotoJavaHashMap;
import org.metaborg.parsetable.query.ProductionToGotoRepresentation;
import org.metaborg.parsetable.states.IState;
import org.metaborg.parsetable.states.IStateFactory;
import org.metaborg.parsetable.states.State;

public class StateFactory
implements IStateFactory {
    private final ActionsForCharacterRepresentation actionsForCharacterRepresentation;
    private final ProductionToGotoRepresentation productionToGotoRepresentation;

    public StateFactory() {
        this(ActionsForCharacterRepresentation.standard(), ProductionToGotoRepresentation.standard());
    }

    public StateFactory(ActionsForCharacterRepresentation actionsForCharacterRepresentation, ProductionToGotoRepresentation productionToGotoType) {
        this.actionsForCharacterRepresentation = actionsForCharacterRepresentation;
        this.productionToGotoRepresentation = productionToGotoType;
    }

    @Override
    public IState from(int stateId, IGoto[] gotos, ActionsPerCharacterClass[] actionsPerCharacterClass, Set<Integer> recoveryStateIds) {
        IProductionToGoto productionToGoto;
        IActionsForCharacter actionsForCharacter;
        switch (this.actionsForCharacterRepresentation) {
            case DisjointSorted: {
                actionsForCharacter = new ActionsForCharacterDisjointSorted(actionsPerCharacterClass, recoveryStateIds);
                break;
            }
            case Separated: {
                actionsForCharacter = new ActionsForCharacterSeparated(actionsPerCharacterClass, recoveryStateIds);
                break;
            }
            default: {
                actionsForCharacter = null;
            }
        }
        switch (this.productionToGotoRepresentation) {
            case ForLoop: {
                productionToGoto = new ProductionToGotoForLoop(gotos);
                break;
            }
            case JavaHashMap: {
                productionToGoto = new ProductionToGotoJavaHashMap(gotos);
                break;
            }
            default: {
                productionToGoto = null;
            }
        }
        return new State(stateId, actionsForCharacter, productionToGoto);
    }
}

