/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.config.ILanguageImplConfig;
import org.metaborg.core.config.LanguageImplConfig;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.IFacet;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageImplInternal;
import org.metaborg.core.language.ILanguageInternal;
import org.metaborg.core.language.LanguageIdentifier;

public class LanguageImplementation
implements ILanguageImpl,
ILanguageImplInternal {
    private final LanguageIdentifier id;
    private final ILanguageInternal belongsTo;
    private final Set<ILanguageComponent> components = Sets.newHashSet();

    public LanguageImplementation(LanguageIdentifier id, ILanguageInternal belongsTo) {
        this.id = id;
        this.belongsTo = belongsTo;
    }

    @Override
    public LanguageIdentifier id() {
        return this.id;
    }

    @Override
    public int sequenceId() {
        int max2 = Integer.MIN_VALUE;
        for (ILanguageComponent component : this.components) {
            max2 = Math.max(component.sequenceId(), max2);
        }
        return max2;
    }

    @Override
    public List<FileObject> locations() {
        LinkedList locations = Lists.newLinkedList();
        for (ILanguageComponent component : this.components) {
            locations.add(component.location());
        }
        return locations;
    }

    @Override
    public Set<ILanguageComponent> components() {
        return this.components;
    }

    @Override
    public ILanguage belongsTo() {
        return this.belongsTo;
    }

    @Override
    public ILanguageInternal belongsToInternal() {
        return this.belongsTo;
    }

    @Override
    public ILanguageImplConfig config() {
        ArrayList configs = Lists.newArrayListWithCapacity((int)this.components.size());
        for (ILanguageComponent component : this.components) {
            configs.add(component.config());
        }
        return new LanguageImplConfig(configs);
    }

    @Override
    public boolean hasFacet(Class<? extends IFacet> type) {
        for (ILanguageComponent component : this.components) {
            if (!component.hasFacet(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends IFacet> Iterable<T> facets(Class<T> type) {
        LinkedList facets = Lists.newLinkedList();
        for (ILanguageComponent component : this.components) {
            Iterables.addAll((Collection)facets, component.facets(type));
        }
        return facets;
    }

    @Override
    public <T extends IFacet> Iterable<FacetContribution<T>> facetContributions(Class<T> type) {
        LinkedList contributions = Lists.newLinkedList();
        for (ILanguageComponent component : this.components) {
            Iterables.addAll((Collection)contributions, component.facetContributions(type));
        }
        return contributions;
    }

    @Override
    public <T extends IFacet> T facet(Class<T> type) {
        Iterable<T> facets = this.facets(type);
        int size = Iterables.size(facets);
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new MetaborgRuntimeException("Multiple facets of type " + type + " found, while only a single facet is supported");
        }
        return (T)((IFacet)Iterables.get(facets, (int)0));
    }

    @Override
    public <T extends IFacet> FacetContribution<T> facetContribution(Class<T> type) {
        Iterable<FacetContribution<T>> facetContributions = this.facetContributions(type);
        int size = Iterables.size(facetContributions);
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new MetaborgRuntimeException("Multiple facets of type " + type + " found, while only a single facet is supported");
        }
        return (FacetContribution)Iterables.get(facetContributions, (int)0);
    }

    @Override
    public Iterable<IFacet> facets() {
        LinkedList facets = Lists.newLinkedList();
        for (ILanguageComponent component : this.components) {
            Iterables.addAll((Collection)facets, component.facets());
        }
        return facets;
    }

    @Override
    public Iterable<FacetContribution<IFacet>> facetContributions() {
        LinkedList contributions = Lists.newLinkedList();
        for (ILanguageComponent component : this.components) {
            Iterables.addAll((Collection)contributions, component.facetContributions());
        }
        return contributions;
    }

    @Override
    public boolean addComponent(ILanguageComponent component) {
        return this.components.add(component);
    }

    @Override
    public boolean removeComponent(ILanguageComponent component) {
        return this.components.remove(component);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageImplementation other = (LanguageImplementation)obj;
        return this.id.equals(other.id);
    }

    public String toString() {
        return "language impl. " + this.id;
    }
}

