/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.metaborg.core.config.IExportConfig;
import org.metaborg.core.config.IGenerateConfig;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.config.ILanguageImplConfig;
import org.metaborg.core.language.LanguageIdentifier;

public class LanguageImplConfig
implements ILanguageImplConfig {
    private final Set<LanguageIdentifier> compileDeps = Sets.newHashSet();
    private final Set<LanguageIdentifier> sourceDeps = Sets.newHashSet();
    private final Set<LanguageIdentifier> javaDeps = Sets.newHashSet();
    private final Collection<IGenerateConfig> generates = Lists.newArrayList();
    private final Collection<IExportConfig> exports = Lists.newArrayList();

    public LanguageImplConfig(Iterable<ILanguageComponentConfig> configs) {
        for (ILanguageComponentConfig config : configs) {
            this.compileDeps.addAll(config.compileDeps());
            this.sourceDeps.addAll(config.sourceDeps());
            this.javaDeps.addAll(config.javaDeps());
            this.generates.addAll(config.generates());
            this.exports.addAll(config.exports());
        }
    }

    @Override
    public Iterable<LanguageIdentifier> compileDeps() {
        return this.compileDeps;
    }

    @Override
    public Iterable<LanguageIdentifier> sourceDeps() {
        return this.sourceDeps;
    }

    @Override
    public Iterable<LanguageIdentifier> javaDeps() {
        return this.javaDeps;
    }

    @Override
    public Iterable<IGenerateConfig> generates() {
        return this.generates;
    }

    @Override
    public Iterable<IExportConfig> exports() {
        return this.exports;
    }
}

