/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.IMessagePrinter;

public class ConfigRequest<T> {
    @Nullable
    private final T config;
    private final Collection<IMessage> errors;

    public ConfigRequest() {
        this(null, Collections.emptyList());
    }

    public ConfigRequest(T config) {
        this(config, Collections.emptyList());
    }

    public ConfigRequest(Collection<IMessage> errors) {
        this(null, errors);
    }

    public ConfigRequest(IMessage error) {
        this(null, Lists.newArrayList((Object[])new IMessage[]{error}));
    }

    public ConfigRequest(@Nullable T config, Collection<IMessage> errors) {
        this.config = config;
        this.errors = errors;
    }

    public boolean valid() {
        return this.errors.isEmpty();
    }

    @Nullable
    public T config() {
        return this.config;
    }

    public Iterable<IMessage> errors() {
        return this.errors;
    }

    public void reportErrors(IMessagePrinter printer) {
        if (this.errors.isEmpty()) {
            return;
        }
        for (IMessage error : this.errors) {
            printer.print(error, false);
        }
        printer.printSummary();
    }
}

