/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.action.ITransformGoal;
import org.metaborg.core.analysis.AnalysisException;
import org.metaborg.core.analysis.IAnalysisService;
import org.metaborg.core.analysis.IAnalyzeResults;
import org.metaborg.core.analysis.IAnalyzeUnit;
import org.metaborg.core.analysis.IAnalyzeUnitUpdate;
import org.metaborg.core.build.BuildInput;
import org.metaborg.core.build.BuildState;
import org.metaborg.core.build.CleanInput;
import org.metaborg.core.build.IBuildOutput;
import org.metaborg.core.build.IBuildOutputInternal;
import org.metaborg.core.build.IBuilder;
import org.metaborg.core.build.LanguageBuildDiff;
import org.metaborg.core.build.LanguageBuildState;
import org.metaborg.core.build.paths.ILanguagePathService;
import org.metaborg.core.context.ContextException;
import org.metaborg.core.context.ContextUtils;
import org.metaborg.core.context.IContext;
import org.metaborg.core.context.IContextService;
import org.metaborg.core.language.ILanguageIdentifierService;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.IdentifiedResource;
import org.metaborg.core.language.LanguagesFileSelector;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.IMessagePrinter;
import org.metaborg.core.messages.MessageFactory;
import org.metaborg.core.messages.MessageSeverity;
import org.metaborg.core.messages.MessageUtils;
import org.metaborg.core.processing.analyze.IAnalysisResultUpdater;
import org.metaborg.core.processing.parse.IParseResultUpdater;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.resource.IdentifiedResourceChange;
import org.metaborg.core.resource.ResourceChange;
import org.metaborg.core.resource.ResourceChangeKind;
import org.metaborg.core.resource.ResourceUtils;
import org.metaborg.core.source.ISourceTextService;
import org.metaborg.core.syntax.IInputUnit;
import org.metaborg.core.syntax.IParseUnit;
import org.metaborg.core.syntax.ISyntaxService;
import org.metaborg.core.syntax.ParseException;
import org.metaborg.core.transform.ITransformOutput;
import org.metaborg.core.transform.ITransformService;
import org.metaborg.core.transform.ITransformUnit;
import org.metaborg.core.transform.TransformException;
import org.metaborg.core.unit.IUnitService;
import org.metaborg.util.RefBool;
import org.metaborg.util.concurrent.IClosableLock;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.resource.FileSelectorUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

public class Builder<I extends IInputUnit, P extends IParseUnit, A extends IAnalyzeUnit, AU extends IAnalyzeUnitUpdate, T extends ITransformUnit<?>, TP extends ITransformUnit<P>, TA extends ITransformUnit<A>>
implements IBuilder<P, A, AU, T> {
    private static final ILogger logger = LoggerUtils.logger(Builder.class);
    private final IResourceService resourceService;
    private final ILanguageIdentifierService languageIdentifier;
    private final ILanguagePathService languagePathService;
    private final IUnitService<I, P, A, AU, TP, TA> unitService;
    private final ISourceTextService sourceTextService;
    private final ISyntaxService<I, P> syntaxService;
    private final IContextService contextService;
    private final IAnalysisService<P, A, AU> analysisService;
    private final ITransformService<P, A, TP, TA> transformService;
    private final IParseResultUpdater<P> parseResultUpdater;
    private final IAnalysisResultUpdater<P, A> analysisResultUpdater;
    private final Provider<IBuildOutputInternal<P, A, AU, T>> buildOutputProvider;

    @Inject
    public Builder(IResourceService resourceService, ILanguageIdentifierService languageIdentifier, ILanguagePathService languagePathService, IUnitService<I, P, A, AU, TP, TA> unitService, ISourceTextService sourceTextService, ISyntaxService<I, P> syntaxService, IContextService contextService, IAnalysisService<P, A, AU> analysisService, ITransformService<P, A, TP, TA> transformService, IParseResultUpdater<P> parseResultUpdater, IAnalysisResultUpdater<P, A> analysisResultUpdater, Provider<IBuildOutputInternal<P, A, AU, T>> buildOutputProvider) {
        this.resourceService = resourceService;
        this.languageIdentifier = languageIdentifier;
        this.languagePathService = languagePathService;
        this.unitService = unitService;
        this.sourceTextService = sourceTextService;
        this.syntaxService = syntaxService;
        this.contextService = contextService;
        this.analysisService = analysisService;
        this.transformService = transformService;
        this.parseResultUpdater = parseResultUpdater;
        this.analysisResultUpdater = analysisResultUpdater;
        this.buildOutputProvider = buildOutputProvider;
    }

    @Override
    public IBuildOutput<P, A, AU, T> build(BuildInput input, IProgress progress, ICancel cancel) throws InterruptedException {
        cancel.throwIfCancelled();
        ArrayListMultimap changes = ArrayListMultimap.create();
        this.identifyResources(input.sourceChanges, input, (Multimap<ILanguageImpl, IdentifiedResourceChange>)changes, cancel);
        if (changes.size() == 0) {
            IBuildOutputInternal buildOutput = (IBuildOutputInternal)this.buildOutputProvider.get();
            buildOutput.setState(input.state);
            return buildOutput;
        }
        cancel.throwIfCancelled();
        logger.info("Building " + input.project.location());
        BuildState newState = new BuildState();
        IBuildOutputInternal buildOutput = (IBuildOutputInternal)this.buildOutputProvider.get();
        buildOutput.setState(newState);
        Iterable<ILanguageImpl> buildOrder = input.buildOrder.buildOrder();
        progress.setWorkRemaining(Iterables.size(buildOrder));
        for (ILanguageImpl language : buildOrder) {
            cancel.throwIfCancelled();
            LanguageBuildState languageState = input.state.get(this.resourceService, this.languageIdentifier, language);
            Collection sourceChanges = changes.get((Object)language);
            if (sourceChanges.size() == 0) {
                newState.add(language, languageState);
                continue;
            }
            Collection includePaths = input.includePaths.get((Object)language);
            Iterable<IdentifiedResource> includeFiles = this.languagePathService.toFiles(includePaths, language);
            LanguageBuildDiff diff = languageState.diff(changes.get((Object)language), includeFiles);
            boolean pardoned = input.pardonedLanguages.contains(language);
            Collection<FileObject> newResources = this.updateLanguageResources(input, language, diff, buildOutput, pardoned, progress.subProgress(1), cancel);
            Iterable<ResourceChange> newResourceChanges = ResourceUtils.toChanges(newResources, ResourceChangeKind.Create);
            this.identifyResources(newResourceChanges, input, (Multimap<ILanguageImpl, IdentifiedResourceChange>)changes, cancel);
            newState.add(language, diff.newState);
        }
        IMessagePrinter printer = input.messagePrinter;
        if (printer != null) {
            printer.printSummary();
        }
        return buildOutput;
    }

    private void identifyResources(Iterable<ResourceChange> changes, BuildInput input, Multimap<ILanguageImpl, IdentifiedResourceChange> identifiedChanges, ICancel cancel) throws InterruptedException {
        Iterable<ILanguageImpl> languages = input.buildOrder.languages();
        FileSelector selector = input.selector;
        FileObject location = input.project.location();
        for (ResourceChange change : changes) {
            IdentifiedResource identifiedResource;
            cancel.throwIfCancelled();
            FileObject resource = change.resource;
            if (selector != null) {
                try {
                    if (!FileSelectorUtils.include(selector, resource, location)) {
                        continue;
                    }
                }
                catch (FileSystemException e) {
                    logger.error("Error determining if {} should be ignored from the build, including it", e, resource);
                }
            }
            if ((identifiedResource = this.languageIdentifier.identifyToResource(resource, languages)) == null) continue;
            IdentifiedResourceChange identifiedChange = new IdentifiedResourceChange(change, identifiedResource);
            identifiedChanges.put((Object)identifiedChange.language, (Object)identifiedChange);
        }
    }

    private Collection<FileObject> updateLanguageResources(BuildInput input, ILanguageImpl language, LanguageBuildDiff diff, IBuildOutputInternal<P, A, AU, T> output, boolean pardoned, IProgress progress, ICancel cancel) throws InterruptedException {
        Multimap<IContext, A> allAnalyzeUnits;
        cancel.throwIfCancelled();
        boolean analyze = input.analyze && this.analysisService.available(language);
        boolean transform = input.transform;
        progress.setWorkRemaining(10 + (analyze ? 70 : 0) + (transform ? 30 : 0));
        Iterable<IdentifiedResourceChange> sourceChanges = diff.sourceChanges;
        Iterable<IdentifiedResourceChange> includeChanges = diff.includeChanges;
        HashSet includes = Sets.newHashSet();
        for (IdentifiedResourceChange includeChange : includeChanges) {
            includes.add(includeChange.change.resource.getName());
        }
        FileObject location = input.project.location();
        HashSet changedSources = Sets.newHashSet();
        HashSet removedResources = Sets.newHashSet();
        LinkedList extraMessages = Lists.newLinkedList();
        RefBool success = new RefBool(true);
        logger.info("Building {} sources, {} includes of {}", Iterables.size(sourceChanges), Iterables.size(includeChanges), language);
        cancel.throwIfCancelled();
        Collection<P> sourceParseUnits = this.parse(input, language, sourceChanges, pardoned, changedSources, removedResources, extraMessages, success, progress.subProgress(5), cancel);
        Collection<P> includeParseUnits = this.parse(input, language, includeChanges, pardoned, changedSources, removedResources, extraMessages, success, progress.subProgress(5), cancel);
        Iterable allParseResults = Iterables.concat(sourceParseUnits, includeParseUnits);
        ArrayListMultimap parseUnitsPerContext = ArrayListMultimap.create();
        for (IParseUnit parseResult : sourceParseUnits) {
            cancel.throwIfCancelled();
            FileObject resource = parseResult.source();
            ILanguageImpl langImpl = parseResult.input().langImpl();
            try {
                IContext context = this.contextService.get(resource, input.project, langImpl);
                parseUnitsPerContext.put((Object)context, (Object)parseResult);
            }
            catch (ContextException e) {
                String string = String.format("Failed to retrieve context for parse result of %s", resource);
                this.printMessageAndMaybeThrow(resource, string, e, input, pardoned);
                extraMessages.add(MessageFactory.newAnalysisErrorAtTop(resource, "Failed to retrieve context", e));
            }
        }
        cancel.throwIfCancelled();
        ArrayList allAnalyzeUpdates = Lists.newArrayList();
        if (analyze) {
            cancel.throwIfCancelled();
            allAnalyzeUnits = this.analyze(input, language, location, (Multimap<IContext, P>)parseUnitsPerContext, (Iterable<P>)includeParseUnits, pardoned, allAnalyzeUpdates, removedResources, extraMessages, success, progress.subProgress(70), cancel);
        } else {
            allAnalyzeUnits = ArrayListMultimap.create();
        }
        cancel.throwIfCancelled();
        Collection<Object> allTransformUnits = transform ? this.transform(input, language, location, (Multimap<IContext, P>)parseUnitsPerContext, allAnalyzeUnits, includes, pardoned, removedResources, extraMessages, success, progress.subProgress(30), cancel) : Lists.newLinkedList();
        boolean noErrors = this.printMessages(extraMessages, input, pardoned);
        if (input.throwOnErrors && !noErrors) {
            throw new MetaborgRuntimeException("Something produced errors");
        }
        output.add(success.get(), removedResources, includes, changedSources, allParseResults, allAnalyzeUnits.values(), allAnalyzeUpdates, (Iterable<Object>)allTransformUnits, extraMessages);
        ArrayList newResources = Lists.newArrayList();
        for (ITransformUnit iTransformUnit : allTransformUnits) {
            for (ITransformOutput transformOutput : iTransformUnit.outputs()) {
                FileObject outputFile = transformOutput.output();
                if (outputFile == null) continue;
                newResources.add(outputFile);
            }
        }
        return newResources;
    }

    private Collection<P> parse(BuildInput input, ILanguageImpl langImpl, Iterable<IdentifiedResourceChange> changes, boolean pardoned, Collection<FileObject> changedResources, Set<FileName> removedResources, Collection<IMessage> extraMessages, RefBool success, IProgress progress, ICancel cancel) throws InterruptedException {
        int size = Iterables.size(changes);
        progress.setWorkRemaining(size);
        ArrayList allParseUnits = Lists.newArrayListWithCapacity((int)size);
        if (size == 0) {
            return allParseUnits;
        }
        progress.setDescription("Parsing " + size + " file(s) of " + langImpl.belongsTo().name());
        logger.debug("Parsing {} resources", size);
        for (IdentifiedResourceChange identifiedChange : changes) {
            String message;
            cancel.throwIfCancelled();
            ResourceChange change = identifiedChange.change;
            FileObject resource = change.resource;
            ILanguageImpl dialect = identifiedChange.dialect;
            ResourceChangeKind changeKind = change.kind;
            try {
                if (changeKind == ResourceChangeKind.Delete) {
                    this.parseResultUpdater.remove(resource);
                    removedResources.add(resource.getName());
                    Object inputUnit = this.unitService.emptyInputUnit(resource, langImpl, dialect);
                    P emptyParseResult = this.unitService.emptyParseUnit(inputUnit);
                    allParseUnits.add(emptyParseResult);
                    progress.work(1);
                    continue;
                }
                String sourceText = this.sourceTextService.text(resource);
                this.parseResultUpdater.invalidate(resource);
                Object inputUnit = this.unitService.inputUnit(resource, sourceText, langImpl, dialect);
                P parseResult = this.syntaxService.parse(inputUnit, progress.subProgress(1), cancel);
                boolean noErrors = this.printMessages(parseResult.messages(), input, pardoned);
                success.and(noErrors);
                allParseUnits.add(parseResult);
                this.parseResultUpdater.update(resource, parseResult);
                changedResources.add(resource);
            }
            catch (ParseException e) {
                message = logger.format("Parsing {} failed unexpectedly", resource);
                boolean noErrors = this.printMessageAndMaybeThrow(resource, message, e, input, pardoned);
                success.and(noErrors);
                this.parseResultUpdater.error(resource, e);
                extraMessages.add(MessageFactory.newParseErrorAtTop(resource, "Parsing failed unexpectedly", e));
                changedResources.add(resource);
            }
            catch (IOException e) {
                message = logger.format("Getting source text for {} failed unexpectedly", resource);
                boolean noErrors = this.printMessageAndMaybeThrow(resource, message, e, input, pardoned);
                success.and(noErrors);
                Object inputUnit = this.unitService.emptyInputUnit(resource, langImpl, dialect);
                this.parseResultUpdater.error(resource, new ParseException((IInputUnit)inputUnit, (Throwable)e));
                extraMessages.add(MessageFactory.newParseErrorAtTop(resource, "Getting source text failed unexpectedly", e));
                changedResources.add(resource);
            }
        }
        if (input.throwOnErrors && !success.get()) {
            throw new MetaborgRuntimeException("Parsing produced errors");
        }
        return allParseUnits;
    }

    private Multimap<IContext, A> analyze(BuildInput input, ILanguageImpl langImpl, FileObject location, Multimap<IContext, P> sourceParseUnits, Iterable<P> includeParseUnits, boolean pardoned, Collection<AU> analyzeUpdates, Set<FileName> removedResources, Collection<IMessage> extraMessages, RefBool success, IProgress progress, ICancel cancel) throws InterruptedException {
        int size = sourceParseUnits.size() + Iterables.size(includeParseUnits);
        ArrayListMultimap allAnalyzeUnits = ArrayListMultimap.create();
        if (size == 0) {
            return allAnalyzeUnits;
        }
        Set toAnalyze = sourceParseUnits.asMap().entrySet();
        int toAnalyzeSize = toAnalyze.size();
        progress.setWorkRemaining(toAnalyzeSize);
        progress.setDescription("Analyzing " + size + " file(s) of " + langImpl.belongsTo().name());
        logger.debug("Analyzing {} parse results in {} context(s)", size, toAnalyzeSize);
        for (Map.Entry entry : toAnalyze) {
            boolean noErrors;
            String message;
            cancel.throwIfCancelled();
            IContext context = (IContext)entry.getKey();
            Iterable parseResults = Iterables.concat((Iterable)((Iterable)entry.getValue()), includeParseUnits);
            try {
                try {
                    Throwable throwable = null;
                    Object var22_25 = null;
                    try (IClosableLock lock = context.write();){
                        boolean noErrors2;
                        this.analysisResultUpdater.invalidate(parseResults);
                        IAnalyzeResults<A, AU> results = this.analysisService.analyzeAll(parseResults, context, progress.subProgress(1), cancel);
                        for (IAnalyzeUnit result : results.results()) {
                            cancel.throwIfCancelled();
                            noErrors2 = this.printMessages(result.messages(), input, pardoned);
                            success.and(noErrors2);
                            this.analysisResultUpdater.update(result, removedResources);
                            allAnalyzeUnits.put((Object)context, (Object)result);
                        }
                        for (IAnalyzeUnitUpdate update : results.updates()) {
                            cancel.throwIfCancelled();
                            noErrors2 = this.printMessages(update.messages(), input, pardoned);
                            success.and(noErrors2);
                            analyzeUpdates.add(update);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                finally {
                    context.persist();
                }
            }
            catch (AnalysisException e) {
                message = "Analysis failed unexpectedly";
                logger.error("Analysis failed unexpectedly", e);
                noErrors = this.printMessageAndMaybeThrow("Analysis failed unexpectedly", e, input, pardoned);
                success.and(noErrors);
                this.analysisResultUpdater.error(parseResults, e);
                extraMessages.add(MessageFactory.newAnalysisErrorAtTop(location, "Analysis failed unexpectedly", e));
            }
            catch (IOException e) {
                message = "Persisting analysis data failed unexpectedly";
                logger.error("Persisting analysis data failed unexpectedly", e);
                noErrors = this.printMessageAndMaybeThrow("Persisting analysis data failed unexpectedly", e, input, pardoned);
                success.and(noErrors);
                extraMessages.add(MessageFactory.newAnalysisErrorAtTop(location, "Persisting analysis data failed unexpectedly", e));
            }
        }
        if (input.throwOnErrors && !success.get()) {
            throw new MetaborgRuntimeException("Analysis produced errors");
        }
        return allAnalyzeUnits;
    }

    private Collection<T> transform(BuildInput input, ILanguageImpl langImpl, FileObject location, Multimap<IContext, P> parseUnits, Multimap<IContext, A> allAnalysisUnits, Set<FileName> includeFiles, boolean pardoned, Set<FileName> removedResources, Collection<IMessage> extraMessages, RefBool success, IProgress progress, ICancel cancel) throws InterruptedException {
        ArrayList allTransformUnits = Lists.newArrayList();
        int numberOfGoals = Iterables.size(input.transformGoals);
        progress.setWorkRemaining(numberOfGoals);
        if (numberOfGoals == 0) {
            return allTransformUnits;
        }
        progress.setDescription("Running " + numberOfGoals + " transformations of " + langImpl.belongsTo().name());
        logger.debug("Running {} transformations", numberOfGoals);
        for (ITransformGoal goal : input.transformGoals) {
            IContext context;
            IProgress transformProgress;
            int size;
            cancel.throwIfCancelled();
            if (this.transformService.requiresAnalysis(langImpl, goal)) {
                size = allAnalysisUnits.size();
                if (size == 0) continue;
                transformProgress = progress.subProgress(1);
                transformProgress.setDescription("Compiling " + size + " file(s) with " + goal);
                logger.debug("Compiling {} analysis results", size);
                for (Map.Entry entry : allAnalysisUnits.asMap().entrySet()) {
                    cancel.throwIfCancelled();
                    context = (IContext)entry.getKey();
                    Collection analysisResults = (Collection)entry.getValue();
                    if (!this.transformService.available(context.language(), goal)) {
                        logger.trace("No {} transformation required for {}", goal, context.language());
                        transformProgress.work(analysisResults.size());
                        continue;
                    }
                    Throwable throwable = null;
                    Iterator iterator = null;
                    try (IClosableLock lock = context.read();){
                        for (IAnalyzeUnit analysisResult : analysisResults) {
                            cancel.throwIfCancelled();
                            FileObject source = analysisResult.source();
                            FileName name = source.getName();
                            if (removedResources.contains(name) || includeFiles.contains(name)) {
                                transformProgress.work(1);
                                continue;
                            }
                            if (!analysisResult.valid()) {
                                logger.warn("Input result for {} is invalid, cannot transform it", source != null ? source.getName().getPath() : "detached source");
                                transformProgress.work(1);
                                continue;
                            }
                            try {
                                Collection<TA> results = this.transformService.transform(analysisResult, context, goal);
                                for (ITransformUnit result : results) {
                                    boolean noErrors = this.printMessages(result.messages(), input, pardoned);
                                    if (input.throwOnErrors && !noErrors) {
                                        throw new MetaborgRuntimeException(goal + " transformation produced errors");
                                    }
                                    success.and(noErrors);
                                    ITransformUnit genericResult = result;
                                    allTransformUnits.add(genericResult);
                                }
                                transformProgress.work(1);
                            }
                            catch (TransformException e) {
                                String message = String.format("Transformation failed unexpectedly for %s", name);
                                logger.error(message, e);
                                boolean noErrors = this.printMessageAndMaybeThrow(source, message, e, input, pardoned);
                                success.and(noErrors);
                                extraMessages.add(MessageFactory.newBuilderErrorAtTop(location, "Transformation failed unexpectedly", e));
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                continue;
            }
            size = parseUnits.size();
            transformProgress = progress.subProgress(1);
            if (size == 0) continue;
            transformProgress.setDescription("Compiling " + size + " file(s) with " + goal);
            logger.debug("Compiling {} parse results", size);
            for (Map.Entry entry : parseUnits.asMap().entrySet()) {
                cancel.throwIfCancelled();
                context = (IContext)entry.getKey();
                Collection parseResults = (Collection)entry.getValue();
                if (!this.transformService.available(context.language(), goal)) {
                    logger.trace("No {} transformation required for {}", goal, context.language());
                    transformProgress.work(parseResults.size());
                    continue;
                }
                for (IParseUnit parseResult : parseResults) {
                    cancel.throwIfCancelled();
                    FileObject source = parseResult.source();
                    FileName name = source.getName();
                    if (removedResources.contains(name) || includeFiles.contains(name)) {
                        transformProgress.work(1);
                        continue;
                    }
                    if (!parseResult.valid()) {
                        logger.warn("Input result for {} is invalid, cannot transform it", source != null ? source.getName().getPath() : "detached source");
                        transformProgress.work(1);
                        continue;
                    }
                    try {
                        Collection<TA> results = this.transformService.transform(parseResult, context, goal);
                        for (ITransformUnit result : results) {
                            boolean noErrors = this.printMessages(result.messages(), input, pardoned);
                            if (input.throwOnErrors && !noErrors) {
                                throw new MetaborgRuntimeException(goal + " transformation produced errors");
                            }
                            success.and(noErrors);
                            ITransformUnit genericResult = result;
                            allTransformUnits.add(genericResult);
                        }
                        transformProgress.work(1);
                    }
                    catch (TransformException e) {
                        String message = String.format("Transformation failed unexpectedly for %s", name);
                        logger.error(message, e);
                        boolean noErrors = this.printMessageAndMaybeThrow(source, message, e, input, pardoned);
                        success.and(noErrors);
                        extraMessages.add(MessageFactory.newBuilderErrorAtTop(location, "Transformation failed unexpectedly", e));
                    }
                }
            }
        }
        return allTransformUnits;
    }

    private boolean printMessages(Iterable<IMessage> messages, BuildInput input, boolean pardoned) {
        IMessagePrinter printer = input.messagePrinter;
        if (printer != null) {
            for (IMessage message : messages) {
                printer.print(message, pardoned);
            }
        }
        boolean failed = !pardoned && MessageUtils.containsSeverity(messages, MessageSeverity.ERROR);
        return !failed;
    }

    private boolean printMessageAndMaybeThrow(@Nullable FileObject resource, String message, @Nullable Throwable e, BuildInput input, boolean pardoned) {
        IMessagePrinter printer = input.messagePrinter;
        if (printer != null) {
            printer.print(resource, message, e, pardoned);
        }
        if (input.throwOnErrors && !pardoned) {
            throw new MetaborgRuntimeException(message, e);
        }
        return pardoned;
    }

    private boolean printMessageAndMaybeThrow(String message, @Nullable Throwable e, BuildInput input, boolean pardoned) {
        IMessagePrinter printer = input.messagePrinter;
        if (printer != null) {
            printer.print(input.project, message, e, pardoned);
        }
        if (input.throwOnErrors && !pardoned) {
            throw new MetaborgRuntimeException(message, e);
        }
        return pardoned;
    }

    @Override
    public void clean(CleanInput input, IProgress progress, ICancel cancel) throws InterruptedException {
        FileObject location = input.project.location();
        logger.debug("Cleaning {}", location);
        LanguagesFileSelector selector = new LanguagesFileSelector(this.languageIdentifier, input.languages);
        if (input.selector != null) {
            selector = FileSelectorUtils.and(selector, input.selector);
        }
        try {
            FileObject[] resources = location.findFiles((FileSelector)selector);
            if (resources == null) {
                return;
            }
            Set<IContext> contexts = ContextUtils.getAll(Iterables2.from(resources), input.project, this.languageIdentifier, this.contextService);
            for (IContext context : contexts) {
                cancel.throwIfCancelled();
                try {
                    context.reset();
                }
                catch (IOException e) {
                    logger.error("Could not clean {}", e, context);
                }
            }
        }
        catch (FileSystemException e) {
            logger.error("Could not clean contexts at {}", e, location);
        }
    }
}

