/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CInequal;
import mb.statix.solver.IConstraint;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.unit.Unit;

public class StateUtil {
    public static List<IConstraint> asConstraint(IUniDisunifier unifier) {
        ImmutableList.Builder constraints = ImmutableList.builder();
        StateUtil.buildEqualities(unifier, arg_0 -> ((ImmutableList.Builder)constraints).add(arg_0));
        StateUtil.buildInequalities(unifier.disequalities(), arg_0 -> ((ImmutableList.Builder)constraints).add(arg_0));
        return constraints.build();
    }

    public static List<CEqual> asEqualities(IUnifier unifier) {
        ImmutableList.Builder constraints = ImmutableList.builder();
        StateUtil.buildEqualities(unifier, arg_0 -> ((ImmutableList.Builder)constraints).add(arg_0));
        return constraints.build();
    }

    public static List<CInequal> asInequalities(IUniDisunifier unifier) {
        ImmutableList.Builder constraints = ImmutableList.builder();
        StateUtil.buildInequalities(unifier.disequalities(), arg_0 -> ((ImmutableList.Builder)constraints).add(arg_0));
        return constraints.build();
    }

    private static void buildEqualities(IUnifier unifier, Action1<CEqual> add2) {
        for (ITermVar var : unifier.domainSet()) {
            add2.apply(new CEqual(var, unifier.findTerm(var)));
        }
    }

    private static void buildInequalities(Iterable<Diseq> diseqs, Action1<CInequal> add2) {
        diseqs.forEach(diseq -> diseq.toTuple().apply((us, left, right) -> {
            add2.apply(new CInequal((Iterable<ITermVar>)us, (ITerm)left, (ITerm)right));
            return Unit.unit;
        }));
    }
}

