/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.diff;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.usethesource.capsule.Set;
import mb.scopegraph.oopsla20.diff.BiMap;
import mb.scopegraph.oopsla20.diff.BiMultimap;
import mb.scopegraph.oopsla20.diff.Edge;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.tuple.Tuple2;

public abstract class DifferState<S, L, D> {

    public static class Immutable<S, L, D>
    extends DifferState<S, L, D> {
        private final BiMap.Immutable<S> matchedScopes;
        private final BiMap.Immutable<Edge<S, L>> matchedEdges;
        private final Set.Immutable<S> seenCurrentScopes;
        private final Set.Immutable<Edge<S, L>> seenCurrentEdges;
        private final Set.Immutable<S> seenPreviousScopes;
        private final Set.Immutable<Edge<S, L>> seenPreviousEdges;
        private final ImmutableMultimap<S, L> edgeDelays;
        private final BiMultimap.Immutable<S, Tuple2<S, L>> dataDelays;

        private Immutable(BiMap.Immutable<S> matchedScopes, BiMap.Immutable<Edge<S, L>> matchedEdges, Set.Immutable<S> seenCurrentScopes, Set.Immutable<Edge<S, L>> seenCurrentEdges, Set.Immutable<S> seenPreviousScopes, Set.Immutable<Edge<S, L>> seenPreviousEdges, ImmutableMultimap<S, L> edgeDelays, BiMultimap.Immutable<S, Tuple2<S, L>> dataDelays) {
            this.matchedScopes = matchedScopes;
            this.matchedEdges = matchedEdges;
            this.seenCurrentScopes = seenCurrentScopes;
            this.seenCurrentEdges = seenCurrentEdges;
            this.seenPreviousScopes = seenPreviousScopes;
            this.seenPreviousEdges = seenPreviousEdges;
            this.edgeDelays = edgeDelays;
            this.dataDelays = dataDelays;
        }

        public BiMap.Immutable<S> matchedScopes() {
            return this.matchedScopes;
        }

        public boolean containsMatchedScopes(S currentScope, S previousScope) {
            return this.matchedScopes.containsEntry(currentScope, previousScope);
        }

        public BiMap.Immutable<Edge<S, L>> matchedEdges() {
            return this.matchedEdges;
        }

        public Set.Immutable<S> seenCurrentScopes() {
            return this.seenCurrentScopes;
        }

        public Set.Immutable<Edge<S, L>> seenCurrentEdges() {
            return this.seenCurrentEdges;
        }

        public Set.Immutable<S> seenPreviousScopes() {
            return this.seenPreviousScopes;
        }

        public Set.Immutable<Edge<S, L>> seenPreviousEdges() {
            return this.seenPreviousEdges;
        }

        public ImmutableMultimap<S, L> edgeDelays() {
            return this.edgeDelays;
        }

        public BiMultimap.Immutable<S, Tuple2<S, L>> dataDelays() {
            return this.dataDelays;
        }

        public Transient<S, L, D> melt() {
            return new Transient(this.matchedScopes.melt(), this.matchedEdges.melt(), this.seenCurrentScopes.asTransient(), this.seenCurrentEdges.asTransient(), this.seenPreviousScopes.asTransient(), this.seenPreviousEdges.asTransient(), (Multimap)ArrayListMultimap.create(this.edgeDelays), this.dataDelays.melt());
        }

        public static <S, L, D> Immutable<S, L, D> of() {
            return new Immutable(BiMap.Immutable.of(), BiMap.Immutable.of(), CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet(), ImmutableMultimap.of(), BiMultimap.Immutable.of());
        }
    }

    public static class Transient<S, L, D>
    extends DifferState<S, L, D> {
        private final BiMap.Transient<S> matchedScopes;
        private final BiMap.Transient<Edge<S, L>> matchedEdges;
        private final Set.Transient<S> seenCurrentScopes;
        private final Set.Transient<Edge<S, L>> seenCurrentEdges;
        private final Set.Transient<S> seenPreviousScopes;
        private final Set.Transient<Edge<S, L>> seenPreviousEdges;
        private final Multimap<S, L> edgeDelays;
        private final BiMultimap.Transient<S, Tuple2<S, L>> dataDelays;

        private Transient(BiMap.Transient<S> matchedScopes, BiMap.Transient<Edge<S, L>> matchedEdges, Set.Transient<S> seenCurrentScopes, Set.Transient<Edge<S, L>> seenCurrentEdges, Set.Transient<S> seenPreviousScopes, Set.Transient<Edge<S, L>> seenPreviousEdges, Multimap<S, L> edgeDelays, BiMultimap.Transient<S, Tuple2<S, L>> dataDelays) {
            this.matchedScopes = matchedScopes;
            this.matchedEdges = matchedEdges;
            this.seenCurrentScopes = seenCurrentScopes;
            this.seenCurrentEdges = seenCurrentEdges;
            this.seenPreviousScopes = seenPreviousScopes;
            this.seenPreviousEdges = seenPreviousEdges;
            this.edgeDelays = edgeDelays;
            this.dataDelays = dataDelays;
        }

        public BiMap.Transient<S> matchedScopes() {
            return this.matchedScopes;
        }

        public void putAllMatchedScopes(BiMap<S> newMatches) {
            this.matchedScopes.putAll(newMatches);
        }

        public boolean canPutMatchedScope(S currentScope, S previousScope) {
            return this.matchedScopes.canPut(currentScope, previousScope);
        }

        public boolean containsMatchedScopes(S currentScope, S previousScope) {
            return this.matchedScopes.containsEntry(currentScope, previousScope);
        }

        public BiMap.Transient<Edge<S, L>> matchedEdges() {
            return this.matchedEdges;
        }

        public void putMatchedEdge(Edge<S, L> currentEdge, Edge<S, L> previousEdge) {
            this.matchedEdges.put(currentEdge, previousEdge);
        }

        public Set.Transient<S> seenCurrentScopes() {
            return this.seenCurrentScopes;
        }

        public Set.Transient<Edge<S, L>> seenCurrentEdges() {
            return this.seenCurrentEdges;
        }

        public Set.Transient<S> seenPreviousScopes() {
            return this.seenPreviousScopes;
        }

        public Set.Transient<Edge<S, L>> seenPreviousEdges() {
            return this.seenPreviousEdges;
        }

        public Multimap<S, L> edgeDelays() {
            return this.edgeDelays;
        }

        public BiMultimap.Transient<S, Tuple2<S, L>> dataDelays() {
            return this.dataDelays;
        }

        public Immutable<S, L, D> freeze() {
            return new Immutable(this.matchedScopes.freeze(), this.matchedEdges.freeze(), this.seenCurrentScopes.freeze(), this.seenCurrentEdges.freeze(), this.seenPreviousScopes.freeze(), this.seenPreviousEdges.freeze(), ImmutableMultimap.copyOf(this.edgeDelays), this.dataDelays.freeze());
        }

        public static <S, L, D> Transient<S, L, D> of() {
            return new Transient(BiMap.Transient.of(), BiMap.Transient.of(), CapsuleUtil.transientSet(), CapsuleUtil.transientSet(), CapsuleUtil.transientSet(), CapsuleUtil.transientSet(), ArrayListMultimap.create(), BiMultimap.Transient.of());
        }
    }
}

