/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.diff;

import io.usethesource.capsule.Map;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public abstract class BiMap<E> {
    public abstract boolean containsKey(E var1);

    public abstract boolean containsValue(E var1);

    public abstract boolean containsEntry(E var1, E var2);

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract Set<E> keySet();

    public abstract Set<E> valueSet();

    public abstract Set<Map.Entry<E, E>> entrySet();

    public static class Immutable<E>
    extends BiMap<E>
    implements Serializable {
        private static final long serialVersionUID = 42L;
        private final Map.Immutable<E, E> fwd;
        private final Map.Immutable<E, E> bwd;

        private Immutable(Map.Immutable<E, E> fwd, Map.Immutable<E, E> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        public boolean containsKey(E key) {
            return this.fwd.containsKey(key);
        }

        @Override
        public boolean containsValue(E value) {
            return this.bwd.containsKey(value);
        }

        @Override
        public boolean containsEntry(E key, E value) {
            return this.fwd.containsKey(key) && this.fwd.get(key).equals(value);
        }

        @Override
        public int size() {
            return this.fwd.size();
        }

        @Override
        public boolean isEmpty() {
            return this.fwd.isEmpty();
        }

        public E getKey(E key) {
            return (E)this.fwd.get(key);
        }

        public E getValue(E value) {
            return (E)this.bwd.get(value);
        }

        public E getKeyOrDefault(E key, E def) {
            return (E)this.fwd.getOrDefault(key, def);
        }

        public E getValueOrDefault(E value, E def) {
            return (E)this.bwd.getOrDefault(value, def);
        }

        @Override
        public Set<E> keySet() {
            return this.fwd.keySet();
        }

        @Override
        public Set<E> valueSet() {
            return this.bwd.keySet();
        }

        @Override
        public Set<Map.Entry<E, E>> entrySet() {
            return this.fwd.entrySet();
        }

        public Immutable<E> putAll(BiMap<E> other) {
            Transient<E> newMap = this.melt();
            newMap.putAll(other);
            return newMap.freeze();
        }

        public Transient<E> melt() {
            return new Transient(this.fwd.asTransient(), this.bwd.asTransient());
        }

        public Map.Immutable<E, E> asMap() {
            return this.fwd;
        }

        public String toString() {
            return this.fwd.toString();
        }

        public static <E> Immutable<E> of() {
            return new Immutable<E>(Map.Immutable.of(), Map.Immutable.of());
        }

        public static <E> Immutable<E> of(E key, E value) {
            return new Immutable<E>(Map.Immutable.of(key, value), Map.Immutable.of(value, key));
        }

        public static <E> Immutable<E> from(BiMap<E> other) {
            Transient<E> newMap = Transient.of();
            newMap.putAll(other);
            return newMap.freeze();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.fwd.equals(((Immutable)obj).fwd);
        }

        public int hashCode() {
            return this.fwd.hashCode();
        }

        public boolean canPut(E key, E value) {
            if (this.fwd.containsKey(key) && !this.fwd.get(key).equals(value)) {
                return false;
            }
            return !this.bwd.containsKey(value) || this.bwd.get(value).equals(key);
        }

        public Immutable<E> put(E key, E value) {
            if (!this.canPut(key, value)) {
                throw new IllegalArgumentException("Key or value already set.");
            }
            return new Immutable<E>(this.fwd.__put(key, value), this.bwd.__put(value, key));
        }

        public Immutable<E> invert() {
            return new Immutable<E>(this.bwd, this.fwd);
        }
    }

    public static class Transient<E>
    extends BiMap<E> {
        private final Map.Transient<E, E> fwd;
        private final Map.Transient<E, E> bwd;

        private Transient(Map.Transient<E, E> fwd, Map.Transient<E, E> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        public boolean containsKey(E key) {
            return this.fwd.containsKey(key);
        }

        @Override
        public boolean containsValue(E value) {
            return this.bwd.containsKey(value);
        }

        @Override
        public boolean containsEntry(E key, E value) {
            return this.fwd.containsKey(key) && this.fwd.get(key).equals(value);
        }

        @Override
        public int size() {
            return this.fwd.size();
        }

        @Override
        public boolean isEmpty() {
            return this.fwd.isEmpty();
        }

        @Override
        public Set<E> keySet() {
            return this.fwd.keySet();
        }

        @Override
        public Set<E> valueSet() {
            return this.bwd.keySet();
        }

        @Override
        public Set<Map.Entry<E, E>> entrySet() {
            return this.fwd.entrySet();
        }

        public boolean canPut(E key, E value) {
            if (this.fwd.containsKey(key) && !this.fwd.get(key).equals(value)) {
                return false;
            }
            return !this.bwd.containsKey(value) || this.bwd.get(value).equals(key);
        }

        public boolean put(E key, E value) {
            if (this.containsEntry(key, value)) {
                return false;
            }
            if (!this.canPut(key, value)) {
                throw new IllegalArgumentException("Key or value already set.");
            }
            this.fwd.__put(key, value);
            this.bwd.__put(value, key);
            return true;
        }

        public boolean putAll(BiMap<E> other) {
            return this.putAll(other.entrySet());
        }

        public boolean putAll(Iterable<Map.Entry<E, E>> entries) {
            boolean changed = false;
            for (Map.Entry<E, E> e : entries) {
                changed |= this.put(e.getKey(), e.getValue());
            }
            return changed;
        }

        public Immutable<E> freeze() {
            return new Immutable(this.fwd.freeze(), this.bwd.freeze());
        }

        public String toString() {
            return this.fwd.toString();
        }

        public static <E> Transient<E> of() {
            return new Transient<E>(Map.Transient.of(), Map.Transient.of());
        }

        public static <E> Transient<E> of(E key, E value) {
            return new Transient<E>(Map.Transient.of(key, value), Map.Transient.of(value, key));
        }

        public E getKey(E key) {
            return (E)this.fwd.get(key);
        }

        public E getValue(E value) {
            return (E)this.bwd.get(value);
        }

        public E getKeyOrDefault(E key, E def) {
            return (E)this.fwd.getOrDefault(key, def);
        }

        public E getValueOrDefault(E value, E def) {
            return (E)this.bwd.getOrDefault(value, def);
        }
    }
}

